/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.core.quarkus37;

import java.beans.ConstructorProperties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class SetupJavaUpgradeJavaVersion
extends Recipe {
    @Option(displayName="Java version", description="The Java version to upgrade to.", example="17")
    private final Integer minimumJavaMajorVersion;
    private static final JsonPathMatcher javaVersion = new JsonPathMatcher("..steps[?(@.uses =~ 'actions/setup-java@v*.*')].with.java-version");
    private static final Pattern javaVersionPattern = Pattern.compile("([0-9]+)(\\.[0-9]+)*([-+].*)?");

    public String getDisplayName() {
        return "Upgrade `actions/setup-java` `java-version`";
    }

    public String getDescription() {
        return "Update the Java version used by `actions/setup-java` if it is below the expected version number.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new YamlVisitor<ExecutionContext>(){

            public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                int currentMajorVersion;
                if (!javaVersion.matches(this.getCursor())) {
                    return super.visitMappingEntry(entry, (Object)ctx);
                }
                Yaml.Scalar currentValue = (Yaml.Scalar)entry.getValue();
                Matcher matcher = javaVersionPattern.matcher(currentValue.getValue());
                if (!matcher.matches()) {
                    return super.visitMappingEntry(entry, (Object)ctx);
                }
                try {
                    currentMajorVersion = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException ex) {
                    return super.visitMappingEntry(entry, (Object)ctx);
                }
                if (currentMajorVersion >= SetupJavaUpgradeJavaVersion.this.minimumJavaMajorVersion) {
                    return super.visitMappingEntry(entry, (Object)ctx);
                }
                return super.visitMappingEntry(entry.withValue((Yaml.Block)currentValue.withValue(String.valueOf(SetupJavaUpgradeJavaVersion.this.minimumJavaMajorVersion))), (Object)ctx);
            }
        });
    }

    @ConstructorProperties(value={"minimumJavaMajorVersion"})
    @Generated
    public SetupJavaUpgradeJavaVersion(Integer minimumJavaMajorVersion) {
        this.minimumJavaMajorVersion = minimumJavaMajorVersion;
    }

    @Generated
    public Integer getMinimumJavaMajorVersion() {
        return this.minimumJavaMajorVersion;
    }

    @NonNull
    @Generated
    public String toString() {
        return "SetupJavaUpgradeJavaVersion(minimumJavaMajorVersion=" + this.getMinimumJavaMajorVersion() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetupJavaUpgradeJavaVersion)) {
            return false;
        }
        SetupJavaUpgradeJavaVersion other = (SetupJavaUpgradeJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$minimumJavaMajorVersion = this.getMinimumJavaMajorVersion();
        Integer other$minimumJavaMajorVersion = other.getMinimumJavaMajorVersion();
        return !(this$minimumJavaMajorVersion == null ? other$minimumJavaMajorVersion != null : !((Object)this$minimumJavaMajorVersion).equals(other$minimumJavaMajorVersion));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SetupJavaUpgradeJavaVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minimumJavaMajorVersion = this.getMinimumJavaMajorVersion();
        result = result * 59 + ($minimumJavaMajorVersion == null ? 43 : ((Object)$minimumJavaMajorVersion).hashCode());
        return result;
    }
}

