/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class StringRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`StringRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `String`s.\n[Source](https://error-prone.picnic.tech/refasterrules/StringRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new EmptyStringRecipe(), new StringIdentityRecipe(), new StringIsEmptyRecipe(), new StringIsEmptyPredicateRecipe(), new StringIsNotEmptyPredicateRecipe(), new StringIsNullOrEmptyRecipe(), new StringIsBlankRecipe(), new OptionalNonEmptyStringRecipe(), new FilterEmptyStringRecipe(), new JoinStringsRecipe(), new StringValueOfRecipe(), new NewStringFromCharArraySubSequenceRecipe(), new NewStringFromCharArrayRecipe(), new StringValueOfMethodReferenceRecipe(), new SubstringRemainderRecipe(), new Utf8EncodedLengthRecipe(), new StringIndexOfCharRecipe(), new StringIndexOfStringRecipe(), new StringLastIndexOfCharRecipe(), new StringLastIndexOfStringRecipe(), new StringLastIndexOfCharWithIndexRecipe(), new StringLastIndexOfStringWithIndexRecipe(), new StringStartsWithRecipe()});
    }

    @NullMarked
    public static class EmptyStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.EmptyString`";
        }

        public String getDescription() {
            return "Avoid unnecessary creation of new empty `String` objects; use the empty string literal instead.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S2129");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate after;

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"new String()").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"\"\"").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"new String(new byte[0], java.nio.charset.StandardCharsets.UTF_8)").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"\"\"").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"new String(new byte[]{}, java.nio.charset.StandardCharsets.UTF_8)").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"\"\"").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"new String(new char[0])").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"\"\"").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$4 == null) {
                        this.before$4 = JavaTemplate.builder((String)"new String(new char[]{})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$4.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"\"\"").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String <init>(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringIdentityRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringIdentity`";
        }

        public String getDescription() {
            return "Avoid unnecessary creation of new `String` objects.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S2129");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"new String(#{str:any(java.lang.String)})").bindType("java.lang.String").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{str:any(java.lang.String)}").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String <init>(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringIsEmpty`";
        }

        public String getDescription() {
            return "Prefer `String#isEmpty()` over alternatives that consult the string's length.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S7158");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.length() == 0").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.isEmpty()").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.length() <= 0").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.isEmpty()").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.length() < 1").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.isEmpty()").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String length(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringIsEmptyPredicateRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringIsEmptyPredicate`";
        }

        public String getDescription() {
            return "Prefer a method reference to `String#isEmpty()` over the equivalent lambda function.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"(s)->s.isEmpty()").bindType("java.util.function.Predicate<java.lang.String>").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"String::isEmpty").bindType("java.util.function.Predicate<java.lang.String>").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitLambda(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesMethod("java.lang.String isEmpty(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringIsNotEmptyPredicateRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringIsNotEmptyPredicate`";
        }

        public String getDescription() {
            return "Prefer a method reference to `String#isEmpty()` over the equivalent lambda function.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"(s)->!s.isEmpty()").bindType("java.util.function.Predicate<java.lang.String>").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.function.Predicate.not(String::isEmpty)").bindType("java.util.function.Predicate<java.lang.String>").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitLambda(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesMethod("java.lang.String isEmpty(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringIsNullOrEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringIsNullOrEmpty`";
        }

        public String getDescription() {
            return "Prefer `Strings#isNullOrEmpty(String)` over the more verbose alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{str:any(java.lang.String)} == null || #{str}.isEmpty()").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.base.Strings.isNullOrEmpty(#{str:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String isEmpty(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringIsBlankRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringIsBlank`";
        }

        public String getDescription() {
            return "Prefer `String#isBlank()` over less efficient alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.trim().isEmpty()").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.isBlank()").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String isEmpty(..)", true), new UsesMethod("java.lang.String trim(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalNonEmptyStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.OptionalNonEmptyString`";
        }

        public String getDescription() {
            return "Don't use the ternary operator to create an optionally-absent string.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.base.Strings.isNullOrEmpty(#{str:any(java.lang.String)}) ? java.util.Optional.empty() : java.util.Optional.of(#{str})").bindType("java.util.Optional<java.lang.String>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.base.Strings");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Optional.ofNullable(#{str:any(java.lang.String)}).filter(java.util.function.Predicate.not(String::isEmpty))").bindType("java.util.Optional<java.lang.String>").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"com.google.common.base.Strings.isNullOrEmpty(#{str:any(java.lang.String)}) ? java.util.Optional.empty() : java.util.Optional.ofNullable(#{str})").bindType("java.util.Optional<java.lang.String>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.base.Strings");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Optional.ofNullable(#{str:any(java.lang.String)}).filter(java.util.function.Predicate.not(String::isEmpty))").bindType("java.util.Optional<java.lang.String>").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.Strings", Boolean.valueOf(true)), new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("com.google.common.base.Strings isNullOrEmpty(..)", true), new UsesMethod("java.util.Optional empty(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Optional of(..)", true), new UsesMethod("java.util.Optional ofNullable(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FilterEmptyStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.FilterEmptyString`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FilterEmptyString {\n    \n    @BeforeTemplate\n    Optional<String> before(Optional<String> optional) {\n        return optional.map(Strings::emptyToNull);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    Optional<String> after(Optional<String> optional) {\n        return optional.filter(not(String::isEmpty));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<java.lang.String>)}.map(com.google.common.base.Strings::emptyToNull)").bindType("java.util.Optional<java.lang.String>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.base.Strings");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<java.lang.String>)}.filter(java.util.function.Predicate.not(String::isEmpty))").bindType("java.util.Optional<java.lang.String>").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.Strings", Boolean.valueOf(true)), new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.Optional map(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JoinStringsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.JoinStrings`";
        }

        public String getDescription() {
            return "Prefer `String#join(CharSequence, Iterable)` and variants over the Guava alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.base.Joiner.on(#{delimiter:any(java.lang.String)}).join(#{elements:any(java.lang.CharSequence[])})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.base.Joiner");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"String.join(#{delimiter:any(java.lang.CharSequence)}, #{elements:any(java.lang.Iterable<? extends java.lang.CharSequence>)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Arrays.stream(#{elements:any(java.lang.CharSequence[])}).collect(java.util.stream.Collectors.joining(#{delimiter:any(java.lang.String)}))").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Arrays");
                        this.maybeRemoveImport("java.util.stream.Collectors.joining");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"String.join(#{delimiter:any(java.lang.CharSequence)}, #{elements:any(java.lang.Iterable<? extends java.lang.CharSequence>)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0$0 == null) {
                        this.before0$0 = JavaTemplate.builder((String)"com.google.common.base.Joiner.on(#{delimiter:any(java.lang.String)}).join(#{elements:any(java.lang.Iterable<? extends java.lang.CharSequence>)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.base.Joiner");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"String.join(#{delimiter:any(java.lang.CharSequence)}, #{elements:any(java.lang.Iterable<? extends java.lang.CharSequence>)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0$1 == null) {
                        this.before0$1 = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(#{elements:any(java.lang.Iterable<? extends java.lang.CharSequence>)}).collect(java.util.stream.Collectors.joining(#{delimiter:any(java.lang.String)}))").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        this.maybeRemoveImport("java.util.stream.Collectors.joining");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"String.join(#{delimiter:any(java.lang.CharSequence)}, #{elements:any(java.lang.Iterable<? extends java.lang.CharSequence>)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before1 == null) {
                        this.before1 = JavaTemplate.builder((String)"#{elements:any(java.util.Collection<? extends java.lang.CharSequence>)}.stream().collect(java.util.stream.Collectors.joining(#{delimiter:any(java.lang.CharSequence)}))").bindType("java.lang.String").build();
                    }
                    if ((matcher = this.before1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Collection");
                        this.maybeRemoveImport("java.util.stream.Collectors.joining");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"String.join(#{delimiter:any(java.lang.CharSequence)}, #{elements:any(java.lang.Iterable<? extends java.lang.CharSequence>)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.Joiner", Boolean.valueOf(true)), new UsesMethod("com.google.common.base.Joiner join(..)", true), new UsesMethod("com.google.common.base.Joiner on(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams stream(..)", true), new UsesMethod("java.util.stream.Collectors joining(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Arrays", Boolean.valueOf(true)), new UsesMethod("java.util.Arrays stream(..)", true), new UsesMethod("java.util.stream.Collectors joining(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Collectors joining(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringValueOfRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringValueOf`";
        }

        public String getDescription() {
            return "Prefer direct invocation of `String#valueOf(Object)` over the indirection introduced by `Objects#toString(Object)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Objects.toString(#{object:any(java.lang.Object)})").bindType("java.lang.String").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Objects");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"String.valueOf(#{object:any(java.lang.Object)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Objects", Boolean.valueOf(true)), new UsesMethod("java.util.Objects toString(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class NewStringFromCharArraySubSequenceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.NewStringFromCharArraySubSequence`";
        }

        public String getDescription() {
            return "Prefer direct invocation of `String#String(char[], int, int)` over the indirection introduced by alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"String.valueOf(#{data:any(char[])}, #{offset:any(int)}, #{count:any(int)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new String(#{data:any(char[])}, #{offset:any(int)}, #{count:any(int)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"String.copyValueOf(#{data:any(char[])}, #{offset:any(int)}, #{count:any(int)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new String(#{data:any(char[])}, #{offset:any(int)}, #{count:any(int)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String copyValueOf(..)", true), new UsesMethod("java.lang.String valueOf(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class NewStringFromCharArrayRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.NewStringFromCharArray`";
        }

        public String getDescription() {
            return "Prefer direct invocation of `String#String(char[])` over the indirection introduced by alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"String.valueOf(#{data:any(char[])})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new String(#{data:any(char[])})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"new String(#{data:any(char[])}, 0, #{data}.length)").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new String(#{data:any(char[])})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"String.valueOf(#{data:any(char[])})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new String(#{data:any(char[])})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"new String(#{data:any(char[])}, 0, #{data}.length)").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"new String(#{data:any(char[])})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String <init>(..)", true), new UsesMethod("java.lang.String valueOf(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringValueOfMethodReferenceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringValueOfMethodReference`";
        }

        public String getDescription() {
            return "Prefer direct delegation to `String#valueOf(Object)` over the indirection introduced by `Objects#toString(Object)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Objects::toString").bindType("java.util.function.Function<java.lang.Object, java.lang.String>").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Objects");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"String::valueOf").bindType("java.util.function.Function<java.lang.Object, java.lang.String>").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitExpression(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Objects", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true))}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SubstringRemainderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.SubstringRemainder`";
        }

        public String getDescription() {
            return "Don't unnecessarily use the two-argument `String#substring(int, int)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.substring(#{index:any(int)}, #{str}.length())").bindType("java.lang.String").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.substring(#{index:any(int)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String length(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class Utf8EncodedLengthRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.Utf8EncodedLength`";
        }

        public String getDescription() {
            return "Prefer `Utf8#encodedLength(CharSequence)` over less efficient alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.getBytes(java.nio.charset.StandardCharsets.UTF_8).length").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.base.Utf8.encodedLength(#{str:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.getBytes(java.nio.charset.StandardCharsets.UTF_8).length").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.base.Utf8.encodedLength(#{str:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String getBytes(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringIndexOfCharRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringIndexOfChar`";
        }

        public String getDescription() {
            return "Prefer `String#indexOf(int, int)` over less efficient alternatives.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4635");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(#{fromIndex:any(int)}).indexOf(#{ch:any(int)})").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Math.max(-1, #{string:any(java.lang.String)}.indexOf(#{ch:any(int)}, #{fromIndex:any(int)}) - #{fromIndex})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String indexOf(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringIndexOfStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringIndexOfString`";
        }

        public String getDescription() {
            return "Prefer `String#indexOf(String, int)` over less efficient alternatives.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4635");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(#{fromIndex:any(int)}).indexOf(#{substring:any(java.lang.String)})").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Math.max(-1, #{string:any(java.lang.String)}.indexOf(#{substring:any(java.lang.String)}, #{fromIndex:any(int)}) - #{fromIndex})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String indexOf(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringLastIndexOfCharRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringLastIndexOfChar`";
        }

        public String getDescription() {
            return "Prefer `String#lastIndexOf(int, int)` over less efficient alternatives.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4635");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(#{fromIndex:any(int)}).lastIndexOf(#{ch:any(int)})").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Math.max(-1, #{string:any(java.lang.String)}.lastIndexOf(#{ch:any(int)}) - #{fromIndex:any(int)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String lastIndexOf(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringLastIndexOfStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringLastIndexOfString`";
        }

        public String getDescription() {
            return "Prefer `String#lastIndexOf(String, int)` over less efficient alternatives.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4635");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(#{fromIndex:any(int)}).lastIndexOf(#{substring:any(java.lang.String)})").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"Math.max(-1, #{string:any(java.lang.String)}.lastIndexOf(#{substring:any(java.lang.String)}) - #{fromIndex:any(int)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String lastIndexOf(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringLastIndexOfCharWithIndexRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringLastIndexOfCharWithIndex`";
        }

        public String getDescription() {
            return "Prefer `String#lastIndexOf(int, int)` over less efficient alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(0, #{fromIndex:any(int)}).lastIndexOf(#{ch:any(int)})").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.lastIndexOf(#{ch:any(int)}, #{fromIndex:any(int)} - 1)").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String lastIndexOf(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringLastIndexOfStringWithIndexRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringLastIndexOfStringWithIndex`";
        }

        public String getDescription() {
            return "Prefer `String#lastIndexOf(String, int)` over less efficient alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(0, #{fromIndex:any(int)}).lastIndexOf(#{substring:any(java.lang.String)})").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.lastIndexOf(#{substring:any(java.lang.String)}, #{fromIndex:any(int)} - 1)").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String lastIndexOf(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringStartsWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.StringStartsWith`";
        }

        public String getDescription() {
            return "Prefer `String#startsWith(String, int)` over less efficient alternatives.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4635");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(#{fromIndex:any(int)}).startsWith(#{prefix:any(java.lang.String)})").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.startsWith(#{prefix:any(java.lang.String)}, #{fromIndex:any(int)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String startsWith(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

