/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.weblogic.rewrite;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class WeblogicVersionHelper {
    private static final LatestRelease LATEST_RELEASE = new LatestRelease(null);
    public static final List<String> LOCAL_VERSIONS = List.of("14.1.1-0-0", "14.1.2-0-0", "15.1.1-0-0");

    public static Optional<String> getNewerVersion(String versionPattern, String currentVersion, ExecutionContext ctx) {
        VersionComparator versionComparator = (VersionComparator)Semver.validate((String)versionPattern, null).getValue();
        assert (versionComparator != null);
        ArrayList<String> availableVersions = new ArrayList<String>();
        for (String v2 : LOCAL_VERSIONS) {
            if (!versionComparator.isValid(null, v2)) continue;
            availableVersions.add(v2);
        }
        return availableVersions.stream().filter(v -> LATEST_RELEASE.compare(null, currentVersion, v) < 0).max((Comparator<String>)LATEST_RELEASE);
    }

    private WeblogicVersionHelper() {
    }
}

