/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.truth;

import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class TruthAssertWithMessageToAssertJ
extends Recipe {
    private static final MethodMatcher ASSERT_WITH_MESSAGE = new MethodMatcher("com.google.common.truth.Truth assertWithMessage(..)");
    private static final MethodMatcher ASSERT_THAT = new MethodMatcher("com.google.common.truth.StandardSubjectBuilder that(..)");

    public String getDisplayName() {
        return "Convert Truth `assertWithMessage` to AssertJ";
    }

    public String getDescription() {
        return "Converts Google Truth's `assertWithMessage().that()` pattern to AssertJ's `assertThat().as()` pattern.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_WITH_MESSAGE), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (mi.getSelect() instanceof J.MethodInvocation) {
                    J.MethodInvocation select = (J.MethodInvocation)mi.getSelect();
                    if (ASSERT_WITH_MESSAGE.matches((MethodCall)select) && ASSERT_THAT.matches((MethodCall)mi)) {
                        List messageArgs = select.getArguments();
                        List actualArgs = mi.getArguments();
                        if (!actualArgs.isEmpty()) {
                            Expression actual = (Expression)actualArgs.get(0);
                            this.maybeRemoveImport("com.google.common.truth.Truth");
                            this.maybeRemoveImport("com.google.common.truth.Truth.assertWithMessage");
                            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat", false);
                            if (messageArgs.size() == 1) {
                                Expression message = (Expression)messageArgs.get(0);
                                return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).as(#{any()})").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{actual, message});
                            }
                            if (messageArgs.size() > 1) {
                                Object[] formatArgs = new Object[messageArgs.size() + 1];
                                formatArgs[0] = actual;
                                for (int i = 0; i < messageArgs.size(); ++i) {
                                    formatArgs[i + 1] = messageArgs.get(i);
                                }
                                String anyAny = String.join((CharSequence)", ", Collections.nCopies(messageArgs.size(), "#{any()}"));
                                return (J.MethodInvocation)JavaTemplate.builder((String)("assertThat(#{any()}).as(String.format(" + anyAny + "))")).staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), formatArgs);
                            }
                        }
                    }
                }
                return mi;
            }
        });
    }
}

