/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.ChangeMethodTargetToStatic;
import org.openrewrite.java.dependencies.FindDependency;
import org.openrewrite.java.testing.mockito.AnyStringToNullable;
import org.openrewrite.java.tree.JavaSourceFile;

public class AnyToNullable
extends ScanningRecipe<AtomicBoolean> {
    public String getDisplayName() {
        return "Replace Mockito 1.x `anyString()`/`any()` with `nullable(Class)`";
    }

    public String getDescription() {
        return "Since Mockito 2.10 `anyString()` and `any()` no longer matches null values. Use `nullable(Class)` instead.";
    }

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean acc) {
        final FindDependency findDependency = new FindDependency("org.mockito", "mockito-all", null, null, null);
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!acc.get() && tree != findDependency.getVisitor().visit(tree, (Object)ctx)) {
                    acc.set(true);
                }
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean acc) {
        return Preconditions.check((boolean)acc.get(), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree preVisit(Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    this.stopAfterPreVisit();
                    this.doAfterVisit(new ChangeMethodName("org.mockito.Mockito any(java.lang.Class)", "nullable", null, null).getVisitor());
                    this.doAfterVisit(new ChangeMethodTargetToStatic("org.mockito.Mockito nullable(java.lang.Class)", "org.mockito.ArgumentMatchers", null, null, Boolean.valueOf(false)).getVisitor());
                    this.doAfterVisit(new AnyStringToNullable().getVisitor());
                }
                return super.preVisit(tree, (Object)ctx);
            }
        });
    }
}

