/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class AssertTrueInstanceofToAssertInstanceOf
extends Recipe {
    public String getDisplayName() {
        return "assertTrue(x instanceof y) to assertInstanceOf(y.class, x)";
    }

    public String getDescription() {
        return "Migration of JUnit4 (or potentially JUnit5) test case in form of assertTrue(x instanceof y) to assertInstanceOf(y.class, x).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J clazz;
                Expression expression;
                J.InstanceOf instanceOf;
                Expression reason;
                Expression argument;
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                MethodMatcher junit5Matcher = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(boolean, ..)");
                MethodMatcher junit4Matcher = new MethodMatcher("org.junit.Assert assertTrue(.., boolean)");
                if (junit5Matcher.matches((MethodCall)mi)) {
                    this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                    argument = (Expression)mi.getArguments().get(0);
                    if (mi.getArguments().size() == 1) {
                        reason = null;
                    } else {
                        if (mi.getArguments().size() != 2) return mi;
                        reason = (Expression)mi.getArguments().get(1);
                    }
                    if (!(argument instanceof J.InstanceOf)) return mi;
                    instanceOf = (J.InstanceOf)argument;
                    expression = instanceOf.getExpression();
                    clazz = instanceOf.getClazz();
                } else {
                    if (!junit4Matcher.matches((MethodCall)mi)) return mi;
                    this.maybeRemoveImport("org.junit.Assert.assertTrue");
                    if (mi.getArguments().size() == 1) {
                        reason = null;
                        argument = (Expression)mi.getArguments().get(0);
                    } else {
                        if (mi.getArguments().size() != 2) return mi;
                        reason = (Expression)mi.getArguments().get(0);
                        argument = (Expression)mi.getArguments().get(1);
                    }
                    if (!(argument instanceof J.InstanceOf)) return mi;
                    instanceOf = (J.InstanceOf)argument;
                    expression = instanceOf.getExpression();
                    clazz = instanceOf.getClazz();
                }
                JavaTemplate template = JavaTemplate.builder((String)("assertInstanceOf(#{}.class, #{any(java.lang.Object)}" + (reason != null ? ", #{any(java.lang.String)})" : ")"))).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9", "junit-4.13"})).staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertInstanceOf"}).build();
                J.MethodInvocation methodd = reason != null ? (J.MethodInvocation)template.apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{clazz.toString(), expression, reason}) : (J.MethodInvocation)template.apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{clazz.toString(), expression});
                this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertInstanceOf");
                return methodd;
            }
        };
    }
}

