/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;

public class AddParameterizedTestAnnotation
extends Recipe {
    private static final AnnotationMatcher TEST_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.Test");
    private static final AnnotationMatcher PARAM_TEST_MATCHER = new AnnotationMatcher("@org.junit.jupiter.params.ParameterizedTest");
    private static final List<AnnotationMatcher> SOURCE_ANNOTATIONS = Stream.of("ValueSource", "CsvSource", "MethodSource", "NullSource", "EmptySource", "NullAndEmptySource", "EnumSource", "CsvFileSource", "ArgumentsSource").map(annotation -> new AnnotationMatcher("@org.junit.jupiter.params.provider." + annotation)).collect(Collectors.toList());

    public String getDisplayName() {
        return "Add missing `@ParameterizedTest` annotation when `@ValueSource` is used or replace `@Test` with `@ParameterizedTest`";
    }

    public String getDescription() {
        return "Add missing `@ParameterizedTest` annotation when `@ValueSource` is used or replace `@Test` with `@ParameterizedTest`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.jupiter.params.provider.*", Boolean.valueOf(false)), (TreeVisitor)new AnnotatedMethodVisitor());
    }

    private static class AnnotatedMethodVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private AnnotatedMethodVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration md, ExecutionContext ctx) {
            J.MethodDeclaration m = super.visitMethodDeclaration(md, (Object)ctx);
            if (m.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)PARAM_TEST_MATCHER).matches(arg_0)) || m.getLeadingAnnotations().stream().noneMatch(ann -> SOURCE_ANNOTATIONS.stream().anyMatch(matcher -> matcher.matches(ann)))) {
                return m;
            }
            JavaCoordinates coordinates = m.getCoordinates().addAnnotation((o1, o2) -> -1);
            m = (J.MethodDeclaration)JavaTemplate.builder((String)"@ParameterizedTest").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-params-5.9"})).imports(new String[]{"org.junit.jupiter.params.ParameterizedTest"}).build().apply(this.getCursor(), coordinates, new Object[0]);
            this.maybeAddImport("org.junit.jupiter.params.ParameterizedTest");
            this.maybeRemoveImport("org.junit.jupiter.api.Test");
            return new RemoveAnnotationVisitor(TEST_ANNOTATION_MATCHER).visitMethodDeclaration(m, ctx);
        }
    }
}

