/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.dependencies.AddDependency;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.xml.tree.Xml;

public final class AddJupiterDependencies
extends ScanningRecipe<AddDependency.Accumulator> {
    public String getDisplayName() {
        return "Add JUnit Jupiter dependencies";
    }

    public String getDescription() {
        return "Adds JUnit Jupiter dependencies to a Maven or Gradle project. Junit Jupiter can be added either with the artifact junit-jupiter, or both of junit-jupiter-api and junit-jupiter-engine. This adds \"junit-jupiter\" dependency unless \"junit-jupiter-api\" or \"junit-jupiter-engine\" are already present.";
    }

    public AddDependency.Accumulator getInitialValue(ExecutionContext ctx) {
        return AddJupiterDependencies.addJupiterDependency().getInitialValue(ctx);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(AddDependency.Accumulator acc) {
        return AddJupiterDependencies.addJupiterDependency().getScanner(acc);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(AddDependency.Accumulator acc) {
        final AddJupiterGradle gv = new AddJupiterGradle(acc);
        final AddJupiterMaven mv = new AddJupiterMaven(acc);
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx, Cursor parent) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile s = (SourceFile)tree;
                if (gv.isAcceptable(s, ctx)) {
                    s = (SourceFile)gv.visitNonNull((Tree)s, ctx);
                }
                if (mv.isAcceptable(s, ctx)) {
                    s = (SourceFile)mv.visitNonNull((Tree)s, ctx);
                }
                return s;
            }
        };
    }

    private static AddDependency addJupiterDependency() {
        return new AddDependency("org.junit.jupiter", "junit-jupiter", "5.x", null, "org.junit..*", null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public AddJupiterDependencies() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddJupiterDependencies()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddJupiterDependencies)) {
            return false;
        }
        AddJupiterDependencies other = (AddJupiterDependencies)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddJupiterDependencies;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static final class AddJupiterGradle
    extends GroovyIsoVisitor<ExecutionContext> {
        private final AddDependency.Accumulator acc;

        public G.CompilationUnit visitCompilationUnit(G.CompilationUnit t, ExecutionContext ctx) {
            Optional maybeGp = t.getMarkers().findFirst(GradleProject.class);
            if (!maybeGp.isPresent()) {
                return t;
            }
            GradleProject gp = (GradleProject)maybeGp.get();
            GradleDependencyConfiguration trc = gp.getConfiguration("testRuntimeClasspath");
            if (trc == null) {
                return t;
            }
            ResolvedDependency jupiterApi = trc.findResolvedDependency("org.junit.jupiter", "junit-jupiter-api");
            if (jupiterApi == null) {
                t = (G.CompilationUnit)AddJupiterDependencies.addJupiterDependency().getVisitor(this.acc).visitNonNull((Tree)t, (Object)ctx);
            }
            return t;
        }

        @ConstructorProperties(value={"acc"})
        @Generated
        public AddJupiterGradle(AddDependency.Accumulator acc) {
            this.acc = acc;
        }

        @Generated
        public AddDependency.Accumulator getAcc() {
            return this.acc;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddJupiterDependencies.AddJupiterGradle(acc=" + this.getAcc() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddJupiterGradle)) {
                return false;
            }
            AddJupiterGradle other = (AddJupiterGradle)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            AddDependency.Accumulator this$acc = this.getAcc();
            AddDependency.Accumulator other$acc = other.getAcc();
            return !(this$acc == null ? other$acc != null : !this$acc.equals(other$acc));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof AddJupiterGradle;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AddDependency.Accumulator $acc = this.getAcc();
            result = result * 59 + ($acc == null ? 43 : $acc.hashCode());
            return result;
        }
    }

    private static final class AddJupiterMaven
    extends MavenIsoVisitor<ExecutionContext> {
        private final AddDependency.Accumulator acc;

        public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
            Xml.Document d = document;
            List jupiterApi = this.getResolutionResult().findDependencies("org.junit.jupiter", "junit-jupiter-api", null);
            if (jupiterApi.isEmpty()) {
                d = (Xml.Document)AddJupiterDependencies.addJupiterDependency().getVisitor(this.acc).visitNonNull((Tree)d, (Object)ctx);
            }
            return d;
        }

        @ConstructorProperties(value={"acc"})
        @Generated
        public AddJupiterMaven(AddDependency.Accumulator acc) {
            this.acc = acc;
        }

        @Generated
        public AddDependency.Accumulator getAcc() {
            return this.acc;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddJupiterDependencies.AddJupiterMaven(acc=" + this.getAcc() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddJupiterMaven)) {
                return false;
            }
            AddJupiterMaven other = (AddJupiterMaven)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            AddDependency.Accumulator this$acc = this.getAcc();
            AddDependency.Accumulator other$acc = other.getAcc();
            return !(this$acc == null ? other$acc != null : !this$acc.equals(other$acc));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof AddJupiterMaven;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AddDependency.Accumulator $acc = this.getAcc();
            result = result * 59 + ($acc == null ? 43 : $acc.hashCode());
            return result;
        }
    }
}

