/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.jmockit;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.testing.jmockit.JMockitBlockRewriter;
import org.openrewrite.java.testing.jmockit.JMockitBlockType;
import org.openrewrite.java.testing.jmockit.JMockitUtils;
import org.openrewrite.java.testing.jmockit.SetupStatementsRewriter;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public final class JMockitBlockToMockito
extends Recipe {
    public String getDisplayName() {
        return "Rewrite JMockit Expectations and Verifications";
    }

    public String getDescription() {
        return "Rewrites JMockit `Expectations and Verifications` blocks to Mockito statements.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(JMockitBlockType.Expectations.getFqn(), Boolean.valueOf(false)), new UsesType(JMockitBlockType.Verifications.getFqn(), Boolean.valueOf(false))}), (TreeVisitor)new RewriteJMockitBlockVisitor());
    }

    @Generated
    public JMockitBlockToMockito() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "JMockitBlockToMockito()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JMockitBlockToMockito)) {
            return false;
        }
        JMockitBlockToMockito other = (JMockitBlockToMockito)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof JMockitBlockToMockito;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class RewriteJMockitBlockVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private RewriteJMockitBlockVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, ExecutionContext ctx) {
            J.MethodDeclaration md = super.visitMethodDeclaration(methodDeclaration, (Object)ctx);
            if (md.getBody() == null) {
                return md;
            }
            SetupStatementsRewriter ssr = new SetupStatementsRewriter((JavaVisitor<ExecutionContext>)this, md.getBody());
            J.Block methodBody = ssr.rewriteMethodBody();
            List statements = methodBody.getStatements();
            int bodyStatementIndex = 0;
            while (bodyStatementIndex < statements.size()) {
                Statement s = (Statement)statements.get(bodyStatementIndex);
                Optional<JMockitBlockType> blockType = JMockitUtils.getJMockitBlock(s);
                if (blockType.isPresent()) {
                    JMockitBlockRewriter blockRewriter = new JMockitBlockRewriter((JavaVisitor<ExecutionContext>)this, ctx, methodBody, (J.NewClass)s, bodyStatementIndex, blockType.get());
                    methodBody = blockRewriter.rewriteMethodBody();
                    statements = methodBody.getStatements();
                    if (!blockRewriter.isRewriteFailed()) continue;
                    ++bodyStatementIndex;
                    continue;
                }
                ++bodyStatementIndex;
            }
            return md.withBody(methodBody);
        }
    }
}

