/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.search.FindDependency;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.ChangeMethodTargetToStatic;
import org.openrewrite.java.testing.mockito.AnyStringToNullable;
import org.openrewrite.java.tree.J;
import org.openrewrite.xml.tree.Xml;

public class AnyToNullable
extends ScanningRecipe<AtomicBoolean> {
    public String getDisplayName() {
        return "Replace Mockito 1.x `anyString()`/`any()` with `nullable(Class)`";
    }

    public String getDescription() {
        return "Since Mockito 2.10 `anyString()` and `any()` no longer matches null values. Use `nullable(Class)` instead.";
    }

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean acc) {
        final org.openrewrite.maven.search.FindDependency mavenFindDependency = new org.openrewrite.maven.search.FindDependency("org.mockito", "mockito-all");
        final FindDependency gradleFindDependency = new FindDependency("org.mockito", "mockito-all", null);
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!acc.get()) {
                    if (tree instanceof Xml.Document && tree != mavenFindDependency.getVisitor().visit(tree, (Object)ctx)) {
                        acc.set(true);
                    } else if (tree instanceof J && tree != gradleFindDependency.getVisitor().visit(tree, (Object)ctx)) {
                        acc.set(true);
                    }
                }
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean acc) {
        final ChangeMethodName changeMethodName = new ChangeMethodName("org.mockito.Mockito any(java.lang.Class)", "nullable", null, null);
        final ChangeMethodTargetToStatic changeMethodTargetToStatic = new ChangeMethodTargetToStatic("org.mockito.Mockito nullable(java.lang.Class)", "org.mockito.ArgumentMatchers", null, null);
        final AnyStringToNullable anyStringToNullable = new AnyStringToNullable();
        return Preconditions.check((boolean)acc.get(), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof J) {
                    this.doAfterVisit(changeMethodName.getVisitor());
                    this.doAfterVisit(changeMethodTargetToStatic.getVisitor());
                    this.doAfterVisit(anyStringToNullable.getVisitor());
                }
                return super.visit(tree, (Object)ctx);
            }
        });
    }
}

