/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class ExpectedExceptionToAssertThrows
extends Recipe {
    public String getDisplayName() {
        return "JUnit 4 `ExpectedException` To JUnit Jupiter's `assertThrows()`";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDescription() {
        return "Replace usages of JUnit 4's `@Rule ExpectedException` with JUnit 5's `Assertions.assertThrows()`.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.junit.rules.ExpectedException");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ExpectedExceptionToAssertThrowsVisitor();
    }

    public static class ExpectedExceptionToAssertThrowsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final Supplier<JavaParser> ASSERTIONS_PARSER = () -> JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api", "hamcrest"}).build();

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            cd = cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), statement -> {
                if (statement instanceof J.VariableDeclarations && TypeUtils.isOfClassType((JavaType)((J.VariableDeclarations)statement).getTypeExpression().getType(), (String)"org.junit.rules.ExpectedException")) {
                    this.maybeRemoveImport("org.junit.Rule");
                    this.maybeRemoveImport("org.junit.rules.ExpectedException");
                    return null;
                }
                return statement;
            })));
            return cd;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDecl, ExecutionContext ctx) {
            J.MethodDeclaration m = super.visitMethodDeclaration(methodDecl, (Object)ctx);
            J.MethodInvocation expectMethodInvocation = (J.MethodInvocation)this.getCursor().pollMessage("expectedExceptionMethodInvocation");
            J.MethodInvocation expectMessageMethodInvocation = (J.MethodInvocation)this.getCursor().pollMessage("expectedExceptionMethodMessageInvocation");
            J.MethodInvocation expectCauseMethodInvocation = (J.MethodInvocation)this.getCursor().pollMessage("expectCauseMethodInvocation");
            if (expectMethodInvocation == null && expectMessageMethodInvocation == null && expectCauseMethodInvocation == null) {
                return m;
            }
            assert (m.getBody() != null);
            J.Block bodyWithoutExpectedExceptionCalls = m.getBody().withStatements(ListUtils.map((List)m.getBody().getStatements(), statement -> ExpectedExceptionToAssertThrowsVisitor.isExpectedExceptionMethodInvocation(statement) ? null : statement));
            boolean isExpectArgAMatcher = false;
            if (expectMethodInvocation != null) {
                List args = expectMethodInvocation.getArguments();
                if (args.size() != 1) {
                    return m;
                }
                Expression expectMethodArg = (Expression)args.get(0);
                isExpectArgAMatcher = this.isHamcrestMatcher((J)expectMethodArg);
                JavaType.FullyQualified argType = TypeUtils.asFullyQualified((JavaType)expectMethodArg.getType());
                if (!(isExpectArgAMatcher || argType != null && "java.lang.Class".equals(argType.getFullyQualifiedName()))) {
                    return m;
                }
            }
            boolean isExpectMessageArgAMatcher = false;
            if (expectMessageMethodInvocation != null) {
                List args = expectMessageMethodInvocation.getArguments();
                if (args.size() != 1) {
                    return m;
                }
                Expression expectMessageMethodArg = (Expression)args.get(0);
                isExpectMessageArgAMatcher = this.isHamcrestMatcher((J)expectMessageMethodArg);
                if (!isExpectMessageArgAMatcher && !TypeUtils.isString((JavaType)expectMessageMethodArg.getType())) {
                    return m;
                }
            }
            boolean isExpectedCauseArgAMatcher = false;
            if (expectCauseMethodInvocation != null) {
                List args = expectCauseMethodInvocation.getArguments();
                if (args.size() != 1) {
                    return m;
                }
                Expression expectCauseMethodArg = (Expression)args.get(0);
                isExpectedCauseArgAMatcher = this.isHamcrestMatcher((J)expectCauseMethodArg);
                if (!isExpectedCauseArgAMatcher) {
                    return m;
                }
            }
            String exceptionDeclParam = isExpectArgAMatcher || isExpectMessageArgAMatcher || isExpectedCauseArgAMatcher || expectMessageMethodInvocation != null ? "Throwable exception =" : "";
            String expectedExceptionParam = expectMethodInvocation == null || isExpectArgAMatcher ? "Exception.class" : expectMethodInvocation.getArguments().get(0);
            String templateString = expectedExceptionParam instanceof String ? "#{} assertThrows(#{}, () -> #{});" : "#{} assertThrows(#{any()}, () -> #{});";
            m = (J.MethodDeclaration)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((ExpectedExceptionToAssertThrowsVisitor)this).getCursor(), (String)templateString).javaParser(ASSERTIONS_PARSER).staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertThrows"}).build(), m.getCoordinates().replaceBody(), new Object[]{exceptionDeclParam, expectedExceptionParam, bodyWithoutExpectedExceptionCalls});
            this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertThrows");
            if (expectMessageMethodInvocation != null && !isExpectMessageArgAMatcher && m.getBody() != null) {
                m = (J.MethodDeclaration)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((ExpectedExceptionToAssertThrowsVisitor)this).getCursor(), (String)"assertTrue(exception.getMessage().contains(#{any(java.lang.String)});").javaParser(ASSERTIONS_PARSER).staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertTrue"}).build(), m.getBody().getCoordinates().lastStatement(), new Object[]{expectMessageMethodInvocation.getArguments().get(0)});
                this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertTrue");
            }
            JavaTemplate assertThatTemplate = JavaTemplate.builder(() -> ((ExpectedExceptionToAssertThrowsVisitor)this).getCursor(), (String)"assertThat(#{}, #{any()});").javaParser(ASSERTIONS_PARSER).staticImports(new String[]{"org.hamcrest.MatcherAssert.assertThat"}).build();
            assert (m.getBody() != null);
            if (isExpectArgAMatcher) {
                m = (J.MethodDeclaration)m.withTemplate((SourceTemplate)assertThatTemplate, m.getBody().getCoordinates().lastStatement(), new Object[]{"exception", expectMethodInvocation.getArguments().get(0)});
                this.maybeAddImport("org.hamcrest.MatcherAssert", "assertThat");
            }
            assert (m.getBody() != null);
            if (isExpectMessageArgAMatcher) {
                m = (J.MethodDeclaration)m.withTemplate((SourceTemplate)assertThatTemplate, m.getBody().getCoordinates().lastStatement(), new Object[]{"exception.getMessage()", expectMessageMethodInvocation.getArguments().get(0)});
                this.maybeAddImport("org.hamcrest.MatcherAssert", "assertThat");
            }
            assert (m.getBody() != null);
            if (isExpectedCauseArgAMatcher) {
                m = (J.MethodDeclaration)m.withTemplate((SourceTemplate)assertThatTemplate, m.getBody().getCoordinates().lastStatement(), new Object[]{"exception.getCause()", expectCauseMethodInvocation.getArguments().get(0)});
                this.maybeAddImport("org.hamcrest.MatcherAssert", "assertThat");
            }
            return m;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (method.getMethodType() != null && "org.junit.rules.ExpectedException".equals(method.getMethodType().getDeclaringType().getFullyQualifiedName())) {
                switch (method.getSimpleName()) {
                    case "expect": {
                        this.getCursor().putMessageOnFirstEnclosing(J.MethodDeclaration.class, "expectedExceptionMethodInvocation", (Object)method);
                        break;
                    }
                    case "expectMessage": {
                        this.getCursor().putMessageOnFirstEnclosing(J.MethodDeclaration.class, "expectedExceptionMethodMessageInvocation", (Object)method);
                        break;
                    }
                    case "expectCause": {
                        this.getCursor().putMessageOnFirstEnclosing(J.MethodDeclaration.class, "expectCauseMethodInvocation", (Object)method);
                    }
                }
            }
            return method;
        }

        private boolean isHamcrestMatcher(J j) {
            if (!(j instanceof J.MethodInvocation)) {
                return false;
            }
            J.MethodInvocation method = (J.MethodInvocation)j;
            return method.getArguments().size() == 1 && method.getMethodType() != null && TypeUtils.isOfClassType((JavaType)method.getMethodType().getDeclaringType(), (String)"org.hamcrest.Matchers");
        }

        private static boolean isExpectedExceptionMethodInvocation(Statement statement) {
            if (!(statement instanceof J.MethodInvocation)) {
                return false;
            }
            J.MethodInvocation m = (J.MethodInvocation)statement;
            if (m.getMethodType() == null) {
                return false;
            }
            return TypeUtils.isOfClassType((JavaType)m.getMethodType().getDeclaringType(), (String)"org.junit.rules.ExpectedException");
        }
    }
}

