/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveTestPrefix
extends Recipe {
    private static final List<String> RESERVED_KEYWORDS = Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "null", "clone", "finalize", "hashCode", "notify", "notifyAll", "toString", "wait");

    public String getDisplayName() {
        return "Remove `test` prefix from JUnit 5 tests";
    }

    public String getDescription() {
        return "Remove `test` from methods with `@Test`, `@ParameterizedTest`, `@RepeatedTest` or `@TestFactory`. They no longer have to prefix test to be usable by JUnit 5.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                this.doAfterVisit((TreeVisitor)new UsesType("org.junit.jupiter.api.Test"));
                this.doAfterVisit((TreeVisitor)new UsesType("org.junit.jupiter.api.TestTemplate"));
                this.doAfterVisit((TreeVisitor)new UsesType("org.junit.jupiter.api.RepeatedTest"));
                this.doAfterVisit((TreeVisitor)new UsesType("org.junit.jupiter.params.ParameterizedTest"));
                this.doAfterVisit((TreeVisitor)new UsesType("org.junit.jupiter.api.TestFactory"));
                return cu;
            }
        };
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveTestPrefixVisitor();
    }

    private static class RemoveTestPrefixVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private RemoveTestPrefixVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
            String newMethodName;
            boolean snakecase;
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)executionContext);
            String simpleName = method.getSimpleName();
            int nameLength = simpleName.length();
            if (nameLength < 5 || !simpleName.startsWith("test") || TypeUtils.isOverride((JavaType.Method)method.getMethodType()) || !RemoveTestPrefixVisitor.hasJUnit5MethodAnnotation(method)) {
                return m;
            }
            boolean bl = snakecase = simpleName.charAt(4) == '_' && 5 < nameLength && Character.isAlphabetic(simpleName.charAt(5));
            if (!snakecase && !Character.isAlphabetic(simpleName.charAt(4))) {
                return m;
            }
            String string = newMethodName = snakecase ? Character.toLowerCase(simpleName.charAt(5)) + simpleName.substring(6) : Character.toLowerCase(simpleName.charAt(4)) + simpleName.substring(5);
            if (RESERVED_KEYWORDS.contains(newMethodName)) {
                return m;
            }
            JavaType.Method type = m.getMethodType();
            if (type == null || this.methodExists(type, newMethodName)) {
                return m;
            }
            type = type.withName(newMethodName);
            return m.withName(m.getName().withSimpleName(newMethodName)).withMethodType(type);
        }

        private boolean methodExists(JavaType.Method method, String newName) {
            return TypeUtils.findDeclaredMethod((JavaType.FullyQualified)method.getDeclaringType(), (String)newName, (List)method.getParameterTypes()).orElse(null) != null;
        }

        private static boolean hasJUnit5MethodAnnotation(J.MethodDeclaration method) {
            for (J.Annotation a : method.getLeadingAnnotations()) {
                if (!TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.Test") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.TestTemplate") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.RepeatedTest") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.params.ParameterizedTest") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.TestFactory")) continue;
                return true;
            }
            return false;
        }
    }
}

