/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.InvocationMatcher;
import org.openrewrite.analysis.search.UsesInvocation;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class ReplaceCollectionToArrayArgWithEmptyArray
extends Recipe {
    public String getDisplayName() {
        return "Use Empty Array for `Collection.toArray()`";
    }

    public String getDescription() {
        return "Changes new array creation with `Collection#toArray(T[])` to use an empty array argument, which is better for performance.\n\nAccording to the `Collection#toArray(T[])` documentation:\n\n> If the collection fits in the specified array, it is returned therein.\n\nHowever, although it's not intuitive, allocating a right-sized array ahead of time to pass to the API appears to be [generally worse for performance](https://shipilev.net/blog/2016/arrays-wisdom-ancients/#_conclusion) according to benchmarking and JVM developers due to a number of implementation details in both Java and the virtual machine.\n\nH2 achieved significant performance gains by [switching to empty arrays instead pre-sized ones](https://github.com/h2database/h2database/issues/311).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesInvocation(ReplaceCollectionToArrayArgWithEmptyArrayVisitor.COLLECTION_TO_ARRAY), new ReplaceCollectionToArrayArgWithEmptyArrayVisitor());
    }

    private static class ReplaceCollectionToArrayArgWithEmptyArrayVisitor<P>
    extends JavaIsoVisitor<P> {
        private static final InvocationMatcher COLLECTION_TO_ARRAY = InvocationMatcher.fromMethodMatcher((String)"java.util.Collection toArray(..)");

        private ReplaceCollectionToArrayArgWithEmptyArrayVisitor() {
        }

        public J.NewArray visitNewArray(J.NewArray newArray, P p) {
            if (COLLECTION_TO_ARRAY.advanced().isFirstArgument(this.getCursor()) && newArray.getDimensions().size() == 1) {
                J.NewArray newArrayZero = newArray.withDimensions(ListUtils.mapFirst((List)newArray.getDimensions(), d -> {
                    if (d.getIndex() instanceof J.Literal && Integer.valueOf(0).equals(((J.Literal)d.getIndex()).getValue())) {
                        return d;
                    }
                    return d.withIndex((Expression)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)0, "0", Collections.emptyList(), (JavaType.Primitive)Objects.requireNonNull(d.getIndex().getType())));
                }));
                return (J.NewArray)this.maybeAutoFormat((J)newArray, (J)newArrayZero, p);
            }
            return super.visitNewArray(newArray, p);
        }
    }
}

