/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Comparator;
import org.jspecify.annotations.NonNull;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class AddSerialAnnotationToSerialVersionUID
extends Recipe {
    public String getDisplayName() {
        return "Add `@Serial` annotation to `serialVersionUID`";
    }

    public String getDescription() {
        return "Annotation any `serialVersionUID` fields with `@Serial` to indicate it's part of the serialization mechanism.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public @NonNull TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(14), new UsesType("java.io.Serializable", Boolean.valueOf(true))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (TypeUtils.isAssignableTo((String)"java.io.Serializable", (JavaType)classDecl.getType())) {
                    return super.visitClassDeclaration(classDecl, (Object)ctx);
                }
                return classDecl;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations vd = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (this.isPrivateStaticFinalLongSerialVersionUID(vd) && FindAnnotations.find((J)vd, (String)"@java.io.Serial").isEmpty()) {
                    this.maybeAddImport("java.io.Serial", false);
                    return (J.VariableDeclarations)JavaTemplate.builder((String)"@Serial").imports(new String[]{"java.io.Serial"}).build().apply(this.getCursor(), vd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                }
                return vd;
            }

            private boolean isPrivateStaticFinalLongSerialVersionUID(J.VariableDeclarations vd) {
                return vd.hasModifier(J.Modifier.Type.Private) && vd.hasModifier(J.Modifier.Type.Static) && vd.hasModifier(J.Modifier.Type.Final) && TypeUtils.asPrimitive((JavaType)vd.getType()) == JavaType.Primitive.Long && vd.getVariables().size() == 1 && "serialVersionUID".equals(((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getSimpleName());
            }
        });
    }
}

