/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.ChangeFieldName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

public final class ReplaceDuplicateStringLiterals
extends Recipe {
    @Option(displayName="Apply recipe to test source set", description="Changes only apply to main by default. `includeTestSources` will apply the recipe to `test` source files.", required=false)
    private final @Nullable Boolean includeTestSources;
    private final int maxVariableLength = 40;

    public String getDisplayName() {
        return "Replace duplicate `String` literals";
    }

    public String getDescription() {
        return "Replaces `String` literals with a length of 5 or greater repeated a minimum of 3 times. Qualified `String` literals include final Strings, method invocations, and new class invocations. Adds a new `private static final String` or uses an existing equivalent class field. A new variable name will be generated based on the literal value if an existing field does not exist. The generated name will append a numeric value to the variable name if a name already exists in the compilation unit.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-1192", "RSPEC-1889"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("java.lang.String", Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)tree;
                    Optional sourceSet = cu.getMarkers().findFirst(JavaSourceSet.class);
                    if (!(Boolean.TRUE.equals(ReplaceDuplicateStringLiterals.this.includeTestSources) || sourceSet.isPresent() && "main".equals(((JavaSourceSet)sourceSet.get()).getName()))) {
                        return cu;
                    }
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (classDecl.getType() == null) {
                    return classDecl;
                }
                DuplicateLiteralInfo duplicateLiteralInfo = DuplicateLiteralInfo.find(classDecl);
                Map<String, List<J.Literal>> duplicateLiteralsMap = duplicateLiteralInfo.getDuplicateLiterals();
                if (duplicateLiteralsMap.isEmpty()) {
                    return classDecl;
                }
                Map<String, String> fieldValueToFieldName = duplicateLiteralInfo.getFieldValueToFieldName();
                Set<String> variableNames = VariableNameUtils.findNamesInScope((Cursor)this.getCursor()).stream().filter(i -> !fieldValueToFieldName.containsValue(i)).collect(Collectors.toSet());
                String classFqn = classDecl.getType().getFullyQualifiedName();
                HashMap<J.Literal, String> replacements = new HashMap<J.Literal, String>();
                for (Map.Entry<String, List<J.Literal>> entry : duplicateLiteralsMap.entrySet()) {
                    String variableName;
                    String valueOfLiteral = entry.getKey();
                    List<J.Literal> duplicateLiterals = duplicateLiteralsMap.get(valueOfLiteral);
                    String classFieldName = fieldValueToFieldName.get(valueOfLiteral);
                    if (classFieldName != null) {
                        String maybeVariableName = this.getNameWithoutShadow(classFieldName, variableNames);
                        if (duplicateLiteralInfo.existingFieldValueToFieldName.get(maybeVariableName) != null) {
                            variableNames.add(maybeVariableName);
                            maybeVariableName = this.getNameWithoutShadow(classFieldName, variableNames);
                        }
                        if (StringUtils.isBlank((String)(variableName = maybeVariableName))) continue;
                        if (!classFieldName.equals(variableName)) {
                            this.doAfterVisit((TreeVisitor)new ChangeFieldName(classFqn, classFieldName, variableName));
                        }
                    } else {
                        variableName = this.getNameWithoutShadow(this.transformToVariableName(valueOfLiteral), variableNames);
                        if (StringUtils.isBlank((String)variableName)) continue;
                        J.Literal replaceLiteral = duplicateLiterals.get(0).withId(Tree.randomId());
                        String modifiers = classDecl.getKind() == J.ClassDeclaration.Kind.Type.Interface ? "" : "private static final ";
                        JavaTemplate template = JavaTemplate.builder((String)(modifiers + "String " + variableName + " = #{any(String)};")).build();
                        if (classDecl.getKind() == J.ClassDeclaration.Kind.Type.Enum) {
                            J.Block applied = (J.Block)template.apply(new Cursor(this.getCursor(), (Object)classDecl.getBody()), classDecl.getBody().getCoordinates().lastStatement(), new Object[]{replaceLiteral});
                            List statements = applied.getStatements();
                            statements.add(1, (Statement)statements.remove(statements.size() - 1));
                            classDecl = classDecl.withBody(applied.withStatements(statements));
                        } else {
                            classDecl = classDecl.withBody((J.Block)template.apply(new Cursor(this.getCursor(), (Object)classDecl.getBody()), classDecl.getBody().getCoordinates().firstStatement(), new Object[]{replaceLiteral}));
                        }
                    }
                    variableNames.add(variableName);
                    entry.getValue().forEach(v -> replacements.put((J.Literal)v, variableName));
                }
                duplicateLiteralInfo = null;
                duplicateLiteralsMap = null;
                return replacements.isEmpty() ? classDecl : (J)new ReplaceStringLiterals(classDecl, replacements).visitNonNull((Tree)classDecl, ctx, Objects.requireNonNull(this.getCursor().getParent()));
            }

            private String getNameWithoutShadow(String name, Set<String> variableNames) {
                String transformedName;
                String newName = transformedName = this.transformToVariableName(name);
                int append = 0;
                while (variableNames.contains(newName)) {
                    newName = transformedName + "_" + ++append;
                }
                return newName;
            }

            private String transformToVariableName(String valueOfLiteral) {
                boolean prevIsLower = false;
                boolean prevIsCharacter = false;
                StringBuilder newName = new StringBuilder();
                for (int i = 0; i < valueOfLiteral.length(); ++i) {
                    char c = valueOfLiteral.charAt(i);
                    if (i > 0 && (Character.isUpperCase(c) && prevIsLower || !prevIsCharacter) && newName.length() > 0 && newName.charAt(newName.length() - 1) != '_') {
                        newName.append('_');
                    }
                    if (!(prevIsCharacter = Character.isLetterOrDigit(c))) continue;
                    if (newName.length() == 0 && Character.isDigit(c)) {
                        newName.append("A_");
                    }
                    newName.append(Character.toUpperCase(c));
                    prevIsLower = Character.isLowerCase(c);
                }
                String newNameString = newName.toString();
                while (newNameString.length() > 40) {
                    int indexOf = newNameString.lastIndexOf("_");
                    newNameString = newNameString.substring(0, indexOf > -1 ? indexOf : 40);
                }
                return VariableNameUtils.normalizeName((String)newNameString);
            }
        });
    }

    private static boolean isPrivateStaticFinalVariable(J.VariableDeclarations.NamedVariable variable) {
        return variable.getVariableType() != null && variable.getVariableType().hasFlags(new Flag[]{Flag.Private, Flag.Static, Flag.Final});
    }

    @Generated
    public ReplaceDuplicateStringLiterals(@Nullable Boolean includeTestSources) {
        this.includeTestSources = includeTestSources;
    }

    @Generated
    public @Nullable Boolean getIncludeTestSources() {
        return this.includeTestSources;
    }

    @Generated
    public int getMaxVariableLength() {
        return this.maxVariableLength;
    }

    @Generated
    public String toString() {
        return "ReplaceDuplicateStringLiterals(includeTestSources=" + this.getIncludeTestSources() + ", maxVariableLength=" + this.getMaxVariableLength() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceDuplicateStringLiterals)) {
            return false;
        }
        ReplaceDuplicateStringLiterals other = (ReplaceDuplicateStringLiterals)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getMaxVariableLength() != other.getMaxVariableLength()) {
            return false;
        }
        Boolean this$includeTestSources = this.getIncludeTestSources();
        Boolean other$includeTestSources = other.getIncludeTestSources();
        return !(this$includeTestSources == null ? other$includeTestSources != null : !((Object)this$includeTestSources).equals(other$includeTestSources));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReplaceDuplicateStringLiterals;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxVariableLength();
        Boolean $includeTestSources = this.getIncludeTestSources();
        result = result * 59 + ($includeTestSources == null ? 43 : ((Object)$includeTestSources).hashCode());
        return result;
    }

    private static final class ReplaceStringLiterals
    extends JavaVisitor<ExecutionContext> {
        private final J.ClassDeclaration isClass;
        private final Map<J.Literal, String> replacements;

        public J visitLiteral(J.Literal literal, ExecutionContext ctx) {
            String variableName = this.replacements.get(literal);
            if (variableName != null) {
                assert (this.isClass.getType() != null);
                return new J.Identifier(Tree.randomId(), literal.getPrefix(), literal.getMarkers(), Collections.emptyList(), variableName, (JavaType)JavaType.Primitive.String, new JavaType.Variable(null, Flag.flagsToBitMap(EnumSet.of(Flag.Private, Flag.Static, Flag.Final)), variableName, (JavaType)this.isClass.getType(), (JavaType)JavaType.Primitive.String, Collections.emptyList()));
            }
            return literal;
        }

        @Generated
        public ReplaceStringLiterals(J.ClassDeclaration isClass, Map<J.Literal, String> replacements) {
            this.isClass = isClass;
            this.replacements = replacements;
        }

        @Generated
        public J.ClassDeclaration getIsClass() {
            return this.isClass;
        }

        @Generated
        public Map<J.Literal, String> getReplacements() {
            return this.replacements;
        }

        @Generated
        public String toString() {
            return "ReplaceDuplicateStringLiterals.ReplaceStringLiterals(isClass=" + this.getIsClass() + ", replacements=" + this.getReplacements() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplaceStringLiterals)) {
                return false;
            }
            ReplaceStringLiterals other = (ReplaceStringLiterals)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            J.ClassDeclaration this$isClass = this.getIsClass();
            J.ClassDeclaration other$isClass = other.getIsClass();
            if (this$isClass == null ? other$isClass != null : !this$isClass.equals(other$isClass)) {
                return false;
            }
            Map<J.Literal, String> this$replacements = this.getReplacements();
            Map<J.Literal, String> other$replacements = other.getReplacements();
            return !(this$replacements == null ? other$replacements != null : !((Object)this$replacements).equals(other$replacements));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReplaceStringLiterals;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            J.ClassDeclaration $isClass = this.getIsClass();
            result = result * 59 + ($isClass == null ? 43 : $isClass.hashCode());
            Map<J.Literal, String> $replacements = this.getReplacements();
            result = result * 59 + ($replacements == null ? 43 : ((Object)$replacements).hashCode());
            return result;
        }
    }

    private static final class DuplicateLiteralInfo {
        private final Map<String, String> fieldValueToFieldName;
        private final Map<String, String> existingFieldValueToFieldName;
        private Map<String, List<J.Literal>> duplicateLiterals;

        public static DuplicateLiteralInfo find(J.ClassDeclaration inClass) {
            final DuplicateLiteralInfo result = new DuplicateLiteralInfo(new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new HashMap<String, List<J.Literal>>());
            new JavaIsoVisitor<Integer>(){

                public J.Annotation visitAnnotation(J.Annotation annotation, Integer integer) {
                    return annotation;
                }

                public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Integer integer) {
                    String value;
                    J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, (Object)integer);
                    Cursor parentScope = this.getCursor().dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.MethodDeclaration);
                    boolean privateStaticFinalVariable = ReplaceDuplicateStringLiterals.isPrivateStaticFinalVariable(variable);
                    if (!(!(v.getInitializer() instanceof J.Literal) || !(parentScope.getValue() instanceof J.MethodDeclaration) && !(parentScope.getValue() instanceof J.ClassDeclaration) || privateStaticFinalVariable && ((J.Literal)v.getInitializer()).getValue() instanceof String || ((J.Literal)v.getInitializer()).getValue() == null)) {
                        value = ((J.Literal)v.getInitializer()).getValue().toString();
                        result.existingFieldValueToFieldName.put(v.getSimpleName(), value);
                    }
                    if (parentScope.getValue() instanceof J.ClassDeclaration && privateStaticFinalVariable && v.getInitializer() instanceof J.Literal && ((J.Literal)v.getInitializer()).getValue() instanceof String) {
                        value = (String)((J.Literal)v.getInitializer()).getValue();
                        result.fieldValueToFieldName.putIfAbsent(value, v.getSimpleName());
                    }
                    return v;
                }

                public J.Literal visitLiteral(J.Literal literal, Integer integer) {
                    if (JavaType.Primitive.String == literal.getType() && literal.getValue() instanceof String && ((String)literal.getValue()).length() >= 5) {
                        Cursor parent = this.getCursor().dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.Annotation || is instanceof J.VariableDeclarations.NamedVariable || is instanceof J.NewClass || is instanceof J.MethodInvocation);
                        if (parent.getValue() instanceof J.NewClass && parent.firstEnclosing(J.EnumValueSet.class) != null) {
                            return literal;
                        }
                        if (parent.getValue() instanceof J.VariableDeclarations.NamedVariable && !ReplaceDuplicateStringLiterals.isPrivateStaticFinalVariable((J.VariableDeclarations.NamedVariable)parent.getValue()) || parent.getValue() instanceof J.NewClass || parent.getValue() instanceof J.MethodInvocation) {
                            result.duplicateLiterals.computeIfAbsent((String)literal.getValue(), k -> new ArrayList(1)).add(literal);
                        }
                    }
                    return literal;
                }
            }.visit((Tree)inClass, (Object)0);
            TreeMap filteredMap = new TreeMap(Comparator.reverseOrder());
            for (Map.Entry<String, List<J.Literal>> entry : result.duplicateLiterals.entrySet()) {
                if (entry.getValue().size() < 3) continue;
                filteredMap.put(entry.getKey(), entry.getValue());
            }
            result.duplicateLiterals = filteredMap;
            return result;
        }

        @Generated
        public DuplicateLiteralInfo(Map<String, String> fieldValueToFieldName, Map<String, String> existingFieldValueToFieldName, Map<String, List<J.Literal>> duplicateLiterals) {
            this.fieldValueToFieldName = fieldValueToFieldName;
            this.existingFieldValueToFieldName = existingFieldValueToFieldName;
            this.duplicateLiterals = duplicateLiterals;
        }

        @Generated
        public Map<String, String> getFieldValueToFieldName() {
            return this.fieldValueToFieldName;
        }

        @Generated
        public Map<String, String> getExistingFieldValueToFieldName() {
            return this.existingFieldValueToFieldName;
        }

        @Generated
        public Map<String, List<J.Literal>> getDuplicateLiterals() {
            return this.duplicateLiterals;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DuplicateLiteralInfo)) {
                return false;
            }
            DuplicateLiteralInfo other = (DuplicateLiteralInfo)o;
            Map<String, String> this$fieldValueToFieldName = this.getFieldValueToFieldName();
            Map<String, String> other$fieldValueToFieldName = other.getFieldValueToFieldName();
            if (this$fieldValueToFieldName == null ? other$fieldValueToFieldName != null : !((Object)this$fieldValueToFieldName).equals(other$fieldValueToFieldName)) {
                return false;
            }
            Map<String, String> this$existingFieldValueToFieldName = this.getExistingFieldValueToFieldName();
            Map<String, String> other$existingFieldValueToFieldName = other.getExistingFieldValueToFieldName();
            if (this$existingFieldValueToFieldName == null ? other$existingFieldValueToFieldName != null : !((Object)this$existingFieldValueToFieldName).equals(other$existingFieldValueToFieldName)) {
                return false;
            }
            Map<String, List<J.Literal>> this$duplicateLiterals = this.getDuplicateLiterals();
            Map<String, List<J.Literal>> other$duplicateLiterals = other.getDuplicateLiterals();
            return !(this$duplicateLiterals == null ? other$duplicateLiterals != null : !((Object)this$duplicateLiterals).equals(other$duplicateLiterals));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $fieldValueToFieldName = this.getFieldValueToFieldName();
            result = result * 59 + ($fieldValueToFieldName == null ? 43 : ((Object)$fieldValueToFieldName).hashCode());
            Map<String, String> $existingFieldValueToFieldName = this.getExistingFieldValueToFieldName();
            result = result * 59 + ($existingFieldValueToFieldName == null ? 43 : ((Object)$existingFieldValueToFieldName).hashCode());
            Map<String, List<J.Literal>> $duplicateLiterals = this.getDuplicateLiterals();
            result = result * 59 + ($duplicateLiterals == null ? 43 : ((Object)$duplicateLiterals).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ReplaceDuplicateStringLiterals.DuplicateLiteralInfo(fieldValueToFieldName=" + this.getFieldValueToFieldName() + ", existingFieldValueToFieldName=" + this.getExistingFieldValueToFieldName() + ", duplicateLiterals=" + this.getDuplicateLiterals() + ")";
        }
    }
}

