/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.staticanalysis.java.JavaFileChecker;

public class UpperCaseLiteralSuffixes
extends Recipe {
    final String displayName = "Upper case literal suffixes";
    final String description = "Using upper case literal suffixes for declaring literals is less ambiguous, e.g., `1l` versus `1L`.";
    final Set<String> tags = Collections.singleton("RSPEC-S818");
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new JavaFileChecker(), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("long", Boolean.valueOf(false)), new UsesType("java.lang.Long", Boolean.valueOf(false)), new UsesType("double", Boolean.valueOf(false)), new UsesType("java.lang.Double", Boolean.valueOf(false)), new UsesType("float", Boolean.valueOf(false)), new UsesType("java.lang.Float", Boolean.valueOf(false))})}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
                String upperValueSource;
                J.Literal initializer;
                J.VariableDeclarations.NamedVariable nv = super.visitVariable(variable, (Object)ctx);
                if (nv.getInitializer() instanceof J.Literal && nv.getInitializer().getType() != null && ((initializer = (J.Literal)nv.getInitializer()).getType() == JavaType.Primitive.Double || initializer.getType() == JavaType.Primitive.Float || initializer.getType() == JavaType.Primitive.Long) && (upperValueSource = this.upperCaseSuffix(initializer.getValueSource())) != null && !upperValueSource.equals(initializer.getValueSource())) {
                    nv = nv.withInitializer((Expression)initializer.withValueSource(upperValueSource));
                }
                return nv;
            }

            private @Nullable String upperCaseSuffix(@Nullable String valueSource) {
                if (valueSource == null || valueSource.length() < 2) {
                    return valueSource;
                }
                return valueSource.substring(0, valueSource.length() - 1) + valueSource.substring(valueSource.length() - 1).toUpperCase();
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

