/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.ChainStringBuilderAppendCalls;

public class ReplaceStringBuilderWithString
extends Recipe {
    private static final MethodMatcher STRING_BUILDER_APPEND = new MethodMatcher("java.lang.StringBuilder append(..)");
    private static final MethodMatcher STRING_BUILDER_TO_STRING = new MethodMatcher("java.lang.StringBuilder toString()");
    final String displayName = "Replace `StringBuilder#append` with `String`";
    final String description = "Replace `StringBuilder.append()` with String if you are only concatenating a small number of strings and the code is simple and easy to read, as the compiler can optimize simple string concatenation expressions into a single String object, which can be more efficient than using StringBuilder.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(STRING_BUILDER_APPEND), new UsesMethod(STRING_BUILDER_TO_STRING)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (STRING_BUILDER_TO_STRING.matches((MethodCall)method)) {
                    List<Expression> arguments = new ArrayList<Expression>();
                    boolean isFlattenable = this.flatMethodInvocationChain(method, arguments);
                    if (!isFlattenable || arguments.isEmpty()) {
                        return m;
                    }
                    Collections.reverse(arguments);
                    arguments = this.adjustExpressions(method, arguments);
                    Expression additive = ChainStringBuilderAppendCalls.additiveExpression(arguments);
                    if (additive == null) {
                        return m;
                    }
                    if (arguments.get(0).getComments().isEmpty() || !arguments.get(0).getPrefix().getWhitespace().startsWith("\n")) {
                        additive = (Expression)additive.withPrefix(method.getPrefix());
                    }
                    if (this.isAMethodSelect(method)) {
                        additive = new J.Parentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)additive));
                    }
                    return additive;
                }
                return m;
            }

            private boolean isAMethodSelect(J.MethodInvocation method) {
                Cursor parent = this.getCursor().getParent(2);
                if (parent == null || !(parent.getValue() instanceof J.MethodInvocation)) {
                    return false;
                }
                return ((J.MethodInvocation)parent.getValue()).getSelect() == method;
            }

            private J.Literal toStringLiteral(J.Literal input) {
                String charSource;
                if (input.getType() == JavaType.Primitive.String) {
                    return input;
                }
                if (input.getType() == JavaType.Primitive.Char && (charSource = input.getValueSource()) != null && charSource.length() >= 2 && charSource.startsWith("'") && charSource.endsWith("'")) {
                    String charContent = charSource.substring(1, charSource.length() - 1);
                    String stringValue = input.getValue() != null ? String.valueOf(input.getValue()) : charContent;
                    String valueSource = "\"" + charContent + "\"";
                    return input.withType((JavaType)JavaType.Primitive.String).withValue((Object)stringValue).withValueSource(valueSource);
                }
                String value = input.getValueSource();
                return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)value, "\"" + value + "\"", null, JavaType.Primitive.String);
            }

            private List<Expression> adjustExpressions(J.MethodInvocation method, List<Expression> arguments) {
                return ListUtils.map(arguments, (i, arg) -> {
                    if (i == 0) {
                        if (!TypeUtils.isString((JavaType)arg.getType())) {
                            if (arg instanceof J.Literal) {
                                return this.toStringLiteral((J.Literal)arg);
                            }
                            return (Expression)JavaTemplate.builder((String)"String.valueOf(#{any()})").build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{arg}).withPrefix(arg.getPrefix());
                        }
                    } else if (!(arg instanceof J.Identifier || arg instanceof J.Literal || arg instanceof J.MethodInvocation)) {
                        return new J.Parentheses(Tree.randomId(), arg.getPrefix(), Markers.EMPTY, JRightPadded.build((Object)arg.withPrefix(Space.EMPTY)));
                    }
                    return arg;
                });
            }

            private boolean flatMethodInvocationChain(J.MethodInvocation method, List<Expression> arguments) {
                Expression select = method.getSelect();
                while (select != null && select instanceof J.MethodInvocation) {
                    J.MethodInvocation selectMethod = (J.MethodInvocation)select;
                    select = selectMethod.getSelect();
                    if (!STRING_BUILDER_APPEND.matches((MethodCall)selectMethod)) {
                        return false;
                    }
                    List args = selectMethod.getArguments();
                    if (args.size() != 1) {
                        return false;
                    }
                    JRightPadded jrp = selectMethod.getPadding().getSelect();
                    if (jrp == null) {
                        arguments.add((Expression)args.get(0));
                        continue;
                    }
                    arguments.add((Expression)((Expression)args.get(0)).withPrefix(jrp.getAfter()));
                }
                if (select instanceof J.NewClass && ((J.NewClass)select).getClazz() != null && TypeUtils.isOfClassType((JavaType)((J.NewClass)select).getClazz().getType(), (String)"java.lang.StringBuilder")) {
                    J.NewClass nc = (J.NewClass)select;
                    if (nc.getArguments().size() == 1 && TypeUtils.isString((JavaType)((Expression)nc.getArguments().get(0)).getType())) {
                        arguments.add((Expression)nc.getArguments().get(0));
                    } else if (!arguments.isEmpty()) {
                        Expression lastArgument = arguments.get(arguments.size() - 1);
                        Space formattedPrefix = lastArgument.getComments().isEmpty() ? Space.EMPTY : lastArgument.getPrefix();
                        arguments.set(arguments.size() - 1, (Expression)lastArgument.withPrefix(formattedPrefix));
                    }
                    return true;
                }
                return false;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

