/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class ReplaceClassIsInstanceWithInstanceof
extends Recipe {
    private static final MethodMatcher ISINSTANCE_MATCHER = new MethodMatcher("java.lang.Class isInstance(..)");
    final String displayName = "Replace `A.class.isInstance(a)` with `a instanceof A`";
    final String description = "There should be no `A.class.isInstance(a)`, it should be replaced by `a instanceof A`.";
    final Set<String> tags = Collections.singleton("RSPEC-S6202");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ISINSTANCE_MATCHER), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (ISINSTANCE_MATCHER.matches((MethodCall)method) && this.isObjectClass(method.getSelect())) {
                    Expression objectExpression = (Expression)method.getArguments().get(0);
                    J.FieldAccess fieldAccessPart = (J.FieldAccess)method.getSelect();
                    JavaCoordinates coordinates = method.getCoordinates().replace();
                    J updated = JavaTemplate.builder((String)"#{any()} instanceof Object").build().apply(this.getCursor(), coordinates, new Object[]{objectExpression});
                    updated = this.mapInstanceOf(updated, instanceOf -> instanceOf.withClazz(fieldAccessPart.getTarget().withPrefix(instanceOf.getClazz().getPrefix())));
                    return this.maybeAutoFormat((J)method, updated, ctx);
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }

            private J mapInstanceOf(J tree, Function<J.InstanceOf, J.InstanceOf> fun) {
                if (tree instanceof J.InstanceOf) {
                    return (J)fun.apply((J.InstanceOf)tree);
                }
                if (tree instanceof J.Parentheses) {
                    J.Parentheses par = (J.Parentheses)tree;
                    J inner = this.mapInstanceOf(par.getTree(), fun);
                    return par.withTree(inner);
                }
                throw new IllegalArgumentException("Expected J.InstanceOf or J.Parentheses, but got: " + tree.getClass());
            }

            private boolean isObjectClass(@Nullable Expression expression) {
                J.FieldAccess fieldAccess;
                if (expression instanceof J.FieldAccess && "class".equals((fieldAccess = (J.FieldAccess)expression).getName().getSimpleName()) && fieldAccess.getTarget() instanceof J.Identifier) {
                    J.Identifier identifier = (J.Identifier)fieldAccess.getTarget();
                    return identifier.getType() instanceof JavaType.Class;
                }
                return false;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

