/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.DeleteStatement;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.VariableReferences;
import org.openrewrite.staticanalysis.javascript.JavascriptFileChecker;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class RemoveUnusedLocalVariables
extends Recipe {
    @Option(displayName="Ignore matching variable names", description="An array of variable identifier names for local variables to ignore, even if the local variable is unused.", required=false, example="[unused, notUsed, IGNORE_ME]")
    @Incubating(since="7.17.2")
    private final String @Nullable [] ignoreVariablesNamed;
    @Option(displayName="Only remove variables of a given type", description="A fully qualified class name. Only unused local variables whose type matches this will be removed. If empty or not set, all unused local variables are considered for removal.", required=false, example="java.lang.String")
    private final @Nullable String withType;
    @Option(displayName="Remove unused local variables with side effects in initializer", description="Whether to remove unused local variables despite side effects in the initializer. Default false.", required=false)
    private final @Nullable Boolean withSideEffects;
    private final String displayName = "Remove unused local variables";
    private final String description = "If a local variable is declared but not used, it is dead code and should be removed.";
    private final Set<String> tags = Collections.singleton("RSPEC-S1481");

    @JsonCreator
    public RemoveUnusedLocalVariables(String @Nullable [] ignoreVariablesNamed, @Nullable String withType, @Nullable Boolean withSideEffects) {
        this.ignoreVariablesNamed = ignoreVariablesNamed;
        this.withType = withType;
        this.withSideEffects = withSideEffects;
    }

    @Deprecated
    public RemoveUnusedLocalVariables(String @Nullable [] ignoreVariablesNamed, @Nullable Boolean withSideEffects) {
        this(ignoreVariablesNamed, null, withSideEffects);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        HashSet<String> ignoreVariableNames;
        final MethodMatcher SAFE_GETTER_METHODS = new MethodMatcher("java.io.File get*(..)");
        if (this.ignoreVariablesNamed == null) {
            ignoreVariableNames = null;
        } else {
            ignoreVariableNames = new HashSet<String>(this.ignoreVariablesNamed.length);
            ignoreVariableNames.addAll(Arrays.asList(this.ignoreVariablesNamed));
        }
        TreeVisitor notJsNorKt = Preconditions.and((TreeVisitor[])new TreeVisitor[]{Preconditions.not(new JavascriptFileChecker()), Preconditions.not(new KotlinFileChecker())});
        return Preconditions.check((TreeVisitor)notJsNorKt, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            private Cursor getCursorToParentScope(Cursor cursor) {
                return cursor.dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.Block || is instanceof J.MethodDeclaration || is instanceof J.ForLoop || is instanceof J.ForEachLoop || is instanceof J.ForLoop.Control || is instanceof J.ForEachLoop.Control || is instanceof J.Case || is instanceof J.Try || is instanceof J.Try.Resource || is instanceof J.Try.Catch || is instanceof J.MultiCatch || is instanceof J.Lambda || is instanceof JavaSourceFile);
            }

            public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, ExecutionContext ctx) {
                return instanceOf;
            }

            public J.DeconstructionPattern visitDeconstructionPattern(J.DeconstructionPattern deconstructionPattern, ExecutionContext ctx) {
                return deconstructionPattern;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
                if (ignoreVariableNames != null && ignoreVariableNames.contains(variable.getSimpleName())) {
                    return variable;
                }
                if (RemoveUnusedLocalVariables.this.withType != null && !TypeUtils.isOfClassType((JavaType)variable.getType(), (String)RemoveUnusedLocalVariables.this.withType)) {
                    return variable;
                }
                Cursor parentScope = this.getCursorToParentScope(this.getCursor());
                J parent = (J)parentScope.getValue();
                if (parentScope.getParent() == null || parentScope.getParent().getValue() instanceof J.ClassDeclaration || parentScope.getValue() instanceof J.ClassDeclaration || parentScope.getParent().getValue() instanceof J.NewClass || parent instanceof J.MethodDeclaration || parent instanceof J.ForLoop.Control || parent instanceof J.ForEachLoop.Control || parent instanceof J.Case || parent instanceof J.Try.Resource || parent instanceof J.Try.Catch || parent instanceof J.MultiCatch || parent instanceof J.Lambda || this.mightSideEffect(variable.getInitializer())) {
                    return variable;
                }
                List<J> readReferences = VariableReferences.findRhsReferences((J)parentScope.getValue(), variable.getName());
                if (readReferences.isEmpty()) {
                    List<Statement> assignmentReferences = VariableReferences.findLhsReferences((J)parentScope.getValue(), variable.getName());
                    for (Statement ref : assignmentReferences) {
                        if (ref instanceof J.Assignment) {
                            if (this.mightSideEffect(((J.Assignment)ref).getAssignment())) {
                                return variable;
                            }
                            this.doAfterVisit((TreeVisitor)new PruneAssignmentExpression((J.Assignment)ref));
                        }
                        this.doAfterVisit((TreeVisitor)new DeleteStatement(ref));
                    }
                    return null;
                }
                return super.visitVariable(variable, (Object)ctx);
            }

            public Statement visitStatement(Statement statement, ExecutionContext ctx) {
                List comments = (List)this.getCursor().pollNearestMessage("COMMENTS_KEY");
                if (comments != null) {
                    statement = (Statement)statement.withComments(ListUtils.concatAll((List)statement.getComments(), (List)comments));
                }
                return super.visitStatement(statement, (Object)ctx);
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                if (!((AnnotationService)this.service(AnnotationService.class)).getAllAnnotations(this.getCursor()).isEmpty()) {
                    return multiVariable;
                }
                J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (mv.getVariables().isEmpty()) {
                    if (!mv.getPrefix().getComments().isEmpty()) {
                        this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).putMessage("COMMENTS_KEY", (Object)mv.getPrefix().getComments());
                    }
                    this.doAfterVisit((TreeVisitor)new DeleteStatement((Statement)mv));
                }
                return mv;
            }

            private boolean mightSideEffect(Expression initializer) {
                return initializer != null && ((AtomicBoolean)new JavaIsoVisitor<AtomicBoolean>(){

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, AtomicBoolean result) {
                        if (SAFE_GETTER_METHODS.matches((MethodCall)methodInvocation)) {
                            return methodInvocation;
                        }
                        if (RemoveUnusedLocalVariables.this.withSideEffects == null || !RemoveUnusedLocalVariables.this.withSideEffects.booleanValue()) {
                            result.set(true);
                        }
                        return methodInvocation;
                    }

                    public J.NewClass visitNewClass(J.NewClass newClass, AtomicBoolean result) {
                        result.set(true);
                        return newClass;
                    }

                    public J.Assignment visitAssignment(J.Assignment assignment, AtomicBoolean result) {
                        result.set(true);
                        return assignment;
                    }
                }.reduce((Tree)initializer, (Object)new AtomicBoolean(false))).get();
            }
        });
    }

    @Generated
    public String @Nullable [] getIgnoreVariablesNamed() {
        return this.ignoreVariablesNamed;
    }

    @Generated
    public @Nullable String getWithType() {
        return this.withType;
    }

    @Generated
    public @Nullable Boolean getWithSideEffects() {
        return this.withSideEffects;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public String toString() {
        return "RemoveUnusedLocalVariables(ignoreVariablesNamed=" + Arrays.deepToString(this.getIgnoreVariablesNamed()) + ", withType=" + this.getWithType() + ", withSideEffects=" + this.getWithSideEffects() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveUnusedLocalVariables)) {
            return false;
        }
        RemoveUnusedLocalVariables other = (RemoveUnusedLocalVariables)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$withSideEffects = this.getWithSideEffects();
        Boolean other$withSideEffects = other.getWithSideEffects();
        if (this$withSideEffects == null ? other$withSideEffects != null : !((Object)this$withSideEffects).equals(other$withSideEffects)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIgnoreVariablesNamed(), other.getIgnoreVariablesNamed())) {
            return false;
        }
        String this$withType = this.getWithType();
        String other$withType = other.getWithType();
        if (this$withType == null ? other$withType != null : !this$withType.equals(other$withType)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveUnusedLocalVariables;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $withSideEffects = this.getWithSideEffects();
        result = result * 59 + ($withSideEffects == null ? 43 : ((Object)$withSideEffects).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getIgnoreVariablesNamed());
        String $withType = this.getWithType();
        result = result * 59 + ($withType == null ? 43 : $withType.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    private static final class AssignmentToLiteral
    extends JavaVisitor<ExecutionContext> {
        private final J.Assignment assignment;

        public J visitAssignment(J.Assignment a, ExecutionContext ctx) {
            if (this.assignment.isScope((Tree)a)) {
                return a.getAssignment().withPrefix(a.getPrefix());
            }
            return a;
        }

        @Generated
        public AssignmentToLiteral(J.Assignment assignment) {
            this.assignment = assignment;
        }

        @Generated
        public J.Assignment getAssignment() {
            return this.assignment;
        }

        @Generated
        public String toString() {
            return "RemoveUnusedLocalVariables.AssignmentToLiteral(assignment=" + this.getAssignment() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssignmentToLiteral)) {
                return false;
            }
            AssignmentToLiteral other = (AssignmentToLiteral)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            J.Assignment this$assignment = this.getAssignment();
            J.Assignment other$assignment = other.getAssignment();
            return !(this$assignment == null ? other$assignment != null : !this$assignment.equals(other$assignment));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AssignmentToLiteral;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            J.Assignment $assignment = this.getAssignment();
            result = result * 59 + ($assignment == null ? 43 : $assignment.hashCode());
            return result;
        }
    }

    private static final class PruneAssignmentExpression
    extends JavaIsoVisitor<ExecutionContext> {
        private final J.Assignment assignment;

        public <T extends J> J.ControlParentheses<T> visitControlParentheses(J.ControlParentheses<T> c, ExecutionContext ctx) {
            return (J.ControlParentheses)new AssignmentToLiteral(this.assignment).visitNonNull((Tree)c, ctx, this.getCursor().getParentOrThrow());
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation m, ExecutionContext ctx) {
            AssignmentToLiteral atl = new AssignmentToLiteral(this.assignment);
            return m.withArguments(ListUtils.map((List)m.getArguments(), it -> {
                if (it instanceof J.Assignment) {
                    return (Expression)atl.visitNonNull((Tree)it, ctx, this.getCursor().getParentOrThrow());
                }
                return it;
            }));
        }

        @Generated
        public PruneAssignmentExpression(J.Assignment assignment) {
            this.assignment = assignment;
        }

        @Generated
        public J.Assignment getAssignment() {
            return this.assignment;
        }

        @Generated
        public String toString() {
            return "RemoveUnusedLocalVariables.PruneAssignmentExpression(assignment=" + this.getAssignment() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PruneAssignmentExpression)) {
                return false;
            }
            PruneAssignmentExpression other = (PruneAssignmentExpression)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            J.Assignment this$assignment = this.getAssignment();
            J.Assignment other$assignment = other.getAssignment();
            return !(this$assignment == null ? other$assignment != null : !this$assignment.equals(other$assignment));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PruneAssignmentExpression;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            J.Assignment $assignment = this.getAssignment();
            result = result * 59 + ($assignment == null ? 43 : $assignment.hashCode());
            return result;
        }
    }
}

