/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveMethodInvocationsVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;

public class RemoveUnneededAssertion
extends Recipe {
    private static final MethodMatcher JUNIT_JUPITER_ASSERT_TRUE_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(..)");
    private static final MethodMatcher JUNIT_JUPITER_ASSERT_FALSE_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertFalse(..)");
    private static final MethodMatcher JUNIT_ASSERT_TRUE_MATCHER = new MethodMatcher("org.junit.Assert assertTrue(boolean)");
    private static final MethodMatcher JUNIT_ASSERT_FALSE_MATCHER = new MethodMatcher("org.junit.Assert assertFalse(boolean)");
    private static final MethodMatcher JUNIT_ASSERT_MESSAGE_TRUE_MATCHER = new MethodMatcher("org.junit.Assert assertTrue(String, boolean)");
    private static final MethodMatcher JUNIT_ASSERT_MESSAGE_FALSE_MATCHER = new MethodMatcher("org.junit.Assert assertFalse(String, boolean)");
    private static final MethodMatcher TEST_NG_ASSERT_TRUE_MATCHER = new MethodMatcher("org.testng.Assert assertTrue(..)");
    private static final MethodMatcher TEST_NG_ASSERT_FALSE_MATCHER = new MethodMatcher("org.testng.Assert assertFalse(..)");
    final String displayName = "Remove unneeded assertions";
    final String description = "Remove unneeded assertions like `assert true`, `assertTrue(true)`, or `assertFalse(false)`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor constraints = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(JUNIT_JUPITER_ASSERT_TRUE_MATCHER), new UsesMethod(JUNIT_JUPITER_ASSERT_FALSE_MATCHER), new UsesMethod(JUNIT_ASSERT_TRUE_MATCHER), new UsesMethod(JUNIT_ASSERT_FALSE_MATCHER), new UsesMethod(JUNIT_ASSERT_MESSAGE_TRUE_MATCHER), new UsesMethod(JUNIT_ASSERT_MESSAGE_FALSE_MATCHER), new UsesMethod(TEST_NG_ASSERT_TRUE_MATCHER), new UsesMethod(TEST_NG_ASSERT_FALSE_MATCHER), new JavaIsoVisitor<ExecutionContext>(){

            public J.Assert visitAssert(J.Assert _assert, ExecutionContext ctx) {
                if (J.Literal.isLiteralValue((Expression)_assert.getCondition(), (Object)true)) {
                    return (J.Assert)SearchResult.found((Tree)_assert);
                }
                return _assert;
            }
        }});
        Predicate<List> isTrue = args -> J.Literal.isLiteralValue((Expression)((Expression)args.get(0)), (Object)true);
        Predicate<List> isFalse = args -> J.Literal.isLiteralValue((Expression)((Expression)args.get(0)), (Object)false);
        final HashMap<MethodMatcher, Predicate<List>> matchers = new HashMap<MethodMatcher, Predicate<List>>();
        matchers.put(JUNIT_JUPITER_ASSERT_TRUE_MATCHER, isTrue);
        matchers.put(JUNIT_JUPITER_ASSERT_FALSE_MATCHER, isFalse);
        matchers.put(JUNIT_ASSERT_TRUE_MATCHER, isTrue);
        matchers.put(JUNIT_ASSERT_FALSE_MATCHER, isFalse);
        matchers.put(JUNIT_ASSERT_MESSAGE_TRUE_MATCHER, args -> J.Literal.isLiteralValue((Expression)((Expression)args.get(1)), (Object)true));
        matchers.put(JUNIT_ASSERT_MESSAGE_FALSE_MATCHER, args -> J.Literal.isLiteralValue((Expression)((Expression)args.get(1)), (Object)false));
        matchers.put(TEST_NG_ASSERT_TRUE_MATCHER, isTrue);
        matchers.put(TEST_NG_ASSERT_FALSE_MATCHER, isFalse);
        return Preconditions.check((TreeVisitor)constraints, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit compilationUnit, ExecutionContext ctx) {
                J.CompilationUnit cu = super.visitCompilationUnit(compilationUnit, (Object)ctx);
                return (J.CompilationUnit)new RemoveMethodInvocationsVisitor(matchers).visitNonNull((Tree)cu, (Object)ctx, this.getCursor().getParentOrThrow());
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.Assert visitAssert(J.Assert _assert, ExecutionContext ctx) {
                if (J.Literal.isLiteralValue((Expression)_assert.getCondition(), (Object)true)) {
                    return null;
                }
                return super.visitAssert(_assert, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

