/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeTree;

@Incubating(since="7.0.0")
public final class NoFinalizedLocalVariables
extends Recipe {
    @Option(displayName="Exclude method parameters", description="If true, do not remove final from method parameters.", required=false)
    private final @Nullable Boolean excludeMethodParameters;
    private final String displayName = "Don't use final on local variables";
    private final String description = "Remove the `final` modifier keyword from local variables regardless of whether they are used within a local class or an anonymous class.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (!mv.hasModifier(J.Modifier.Type.Final)) {
                    return mv;
                }
                Tree parent = (Tree)this.getCursor().getParentTreeCursor().getValue();
                if (parent instanceof J.MethodDeclaration || parent instanceof J.Lambda || parent instanceof J.Lambda.Parameters) {
                    if (Boolean.TRUE.equals(NoFinalizedLocalVariables.this.excludeMethodParameters)) {
                        return mv;
                    }
                    return this.removeFinal(mv);
                }
                Iterator cursorPath = this.getCursor().getPath();
                while (cursorPath.hasNext()) {
                    Object next = cursorPath.next();
                    if (!(next instanceof J.Block)) continue;
                    while (cursorPath.hasNext()) {
                        next = cursorPath.next();
                        if (next instanceof J.ClassDeclaration || next instanceof J.NewClass) {
                            return mv;
                        }
                        if (!(next instanceof J.MethodDeclaration) && !(next instanceof J.Lambda)) continue;
                        return this.removeFinal(mv);
                    }
                    break block0;
                }
                return mv;
            }

            private J.VariableDeclarations removeFinal(J.VariableDeclarations mv) {
                J.VariableDeclarations v = mv.withModifiers(ListUtils.map((List)mv.getModifiers(), m -> m.getType() == J.Modifier.Type.Final ? null : m));
                if (v.getModifiers().isEmpty() && v.getTypeExpression() != null) {
                    v = v.withTypeExpression((TypeTree)v.getTypeExpression().withPrefix(v.getTypeExpression().getPrefix().withWhitespace(v.getLeadingAnnotations().isEmpty() ? "" : " ")));
                }
                return v;
            }
        };
    }

    @Generated
    public NoFinalizedLocalVariables(@Nullable Boolean excludeMethodParameters) {
        this.excludeMethodParameters = excludeMethodParameters;
    }

    @Generated
    public @Nullable Boolean getExcludeMethodParameters() {
        return this.excludeMethodParameters;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "NoFinalizedLocalVariables(excludeMethodParameters=" + this.getExcludeMethodParameters() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NoFinalizedLocalVariables)) {
            return false;
        }
        NoFinalizedLocalVariables other = (NoFinalizedLocalVariables)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$excludeMethodParameters = this.getExcludeMethodParameters();
        Boolean other$excludeMethodParameters = other.getExcludeMethodParameters();
        if (this$excludeMethodParameters == null ? other$excludeMethodParameters != null : !((Object)this$excludeMethodParameters).equals(other$excludeMethodParameters)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NoFinalizedLocalVariables;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $excludeMethodParameters = this.getExcludeMethodParameters();
        result = result * 59 + ($excludeMethodParameters == null ? 43 : ((Object)$excludeMethodParameters).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

