/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.staticanalysis.csharp.CSharpFileChecker;

public class NestedEnumsAreNotStatic
extends Recipe {
    final String displayName = "Nested enums are not static";
    final String description = "Remove static modifier from nested enum types since they are implicitly static.";
    final Set<String> tags = Collections.singleton("RSPEC-S2786");
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not(new CSharpFileChecker()), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (this.shouldRemoveStaticModifierFromClass(cd)) {
                    return (J.ClassDeclaration)this.maybeAutoFormat((J)cd, (J)cd.withModifiers(ListUtils.filter((List)cd.getModifiers(), mod -> mod.getType() != J.Modifier.Type.Static)), (J)cd.getName(), ctx, this.getCursor().getParent());
                }
                return cd;
            }

            private boolean shouldRemoveStaticModifierFromClass(J.ClassDeclaration cd) {
                return cd.getKind() == J.ClassDeclaration.Kind.Type.Enum && cd.getType() != null && cd.getType().getOwningClass() != null && J.Modifier.hasModifier((Collection)cd.getModifiers(), (J.Modifier.Type)J.Modifier.Type.Static);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

