/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public final class MaskCreditCardNumbers
extends Recipe {
    private final String displayName = "Mask credit card numbers";
    private final String description = "When encountering string literals which appear to be credit card numbers, mask the last eight digits with the letter 'X'.";
    private static final Pattern CC_PATTERN = Pattern.compile("([0-9]{4} ?[0-9]{4} ?)([0-9]{4} ?[0-9]{4} ?)");
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\d");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                J.Literal l = super.visitLiteral(literal, (Object)ctx);
                if (l.getValue() instanceof String) {
                    String value = (String)l.getValue();
                    Matcher m = CC_PATTERN.matcher(value);
                    if (m.matches()) {
                        String masked = m.group(1) + MaskCreditCardNumbers.maskDigits(m.group(2));
                        l = l.withValue((Object)masked).withValueSource("\"" + masked + "\"");
                    }
                }
                return l;
            }
        };
    }

    private static String maskDigits(String digits) {
        return DIGIT_PATTERN.matcher(digits).replaceAll("X");
    }

    @Generated
    public MaskCreditCardNumbers() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "MaskCreditCardNumbers(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaskCreditCardNumbers)) {
            return false;
        }
        MaskCreditCardNumbers other = (MaskCreditCardNumbers)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MaskCreditCardNumbers;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

