/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangePackage;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class LowercasePackage
extends ScanningRecipe<Map<String, String>> {
    final String displayName = "Rename packages to lowercase";
    final String description = "By convention all Java package names should contain only lowercase letters, numbers, and dashes. This recipe converts any uppercase letters in package names to be lowercase.";
    final Set<String> tags = Collections.singleton("RSPEC-S120");

    public Map<String, String> getInitialValue(ExecutionContext ctx) {
        return new HashMap<String, String>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Map<String, String> acc) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public @Nullable J preVisit(J tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    String lowerCase;
                    String packageText;
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    J.Package pkg = cu.getPackageDeclaration();
                    if (pkg != null && !(packageText = LowercasePackage.this.getPackageText(this.getCursor(), pkg)).equals(lowerCase = packageText.toLowerCase())) {
                        acc.put(packageText, lowerCase);
                    }
                    this.stopAfterPreVisit();
                }
                return (J)super.preVisit((Tree)tree, (Object)ctx);
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Map<String, String> acc) {
        return Preconditions.check((!acc.isEmpty() ? 1 : 0) != 0, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J preVisit(J tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    String packageText;
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    J.Package pkg = cu.getPackageDeclaration();
                    if (pkg != null && acc.containsKey(packageText = LowercasePackage.this.getPackageText(this.getCursor(), pkg))) {
                        return (JavaSourceFile)new ChangePackage(packageText, (String)acc.get(packageText), Boolean.valueOf(true)).getVisitor().visitNonNull((Tree)cu, (Object)ctx);
                    }
                    this.stopAfterPreVisit();
                }
                return tree;
            }
        });
    }

    private String getPackageText(Cursor cursor, J.Package pkg) {
        return pkg.getExpression().print(cursor).replaceAll("\\s", "");
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

