/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.staticanalysis.JavaElementFactory;

public class IsEmptyCallOnCollections
extends Recipe {
    private static final MethodMatcher COLLECTION_SIZE = new MethodMatcher("java.util.Collection size()", true);
    final String displayName = "Use `Collection#isEmpty()` instead of comparing `size()`";
    final String description = "Also check for _not_ `isEmpty()` when testing for not equal to zero size.";
    final Set<String> tags = new LinkedHashSet<String>(Arrays.asList("RSPEC-S1155", "RSPEC-S3981"));
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(COLLECTION_SIZE), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitBinary(J.Binary binary, ExecutionContext ctx) {
                boolean oneRight;
                if (IsEmptyCallOnCollections.isZero(binary.getLeft()) || IsEmptyCallOnCollections.isZero(binary.getRight())) {
                    boolean zeroRight = IsEmptyCallOnCollections.isZero(binary.getRight());
                    if (binary.getOperator() == J.Binary.Type.Equal || binary.getOperator() == J.Binary.Type.NotEqual || zeroRight && binary.getOperator() == J.Binary.Type.GreaterThan || !zeroRight && binary.getOperator() == J.Binary.Type.LessThan) {
                        Expression maybeSizeCall;
                        Expression expression = maybeSizeCall = zeroRight ? binary.getLeft() : binary.getRight();
                        if (maybeSizeCall instanceof J.MethodInvocation) {
                            J.MethodInvocation maybeSizeCallMethod = (J.MethodInvocation)maybeSizeCall;
                            if (COLLECTION_SIZE.matches((MethodCall)maybeSizeCallMethod) && maybeSizeCallMethod.getMethodType() != null) {
                                return this.newIsEmptyCall(maybeSizeCallMethod, binary.getCoordinates().replace(), binary.getOperator() != J.Binary.Type.Equal).withPrefix(binary.getPrefix());
                            }
                        }
                    }
                } else if ((IsEmptyCallOnCollections.isOne(binary.getLeft()) || IsEmptyCallOnCollections.isOne(binary.getRight())) && ((oneRight = IsEmptyCallOnCollections.isOne(binary.getRight())) && binary.getOperator() == J.Binary.Type.LessThan || !oneRight && binary.getOperator() == J.Binary.Type.GreaterThan || oneRight && binary.getOperator() == J.Binary.Type.GreaterThanOrEqual || !oneRight && binary.getOperator() == J.Binary.Type.LessThanOrEqual)) {
                    Expression maybeSizeCall;
                    Expression expression = maybeSizeCall = oneRight ? binary.getLeft() : binary.getRight();
                    if (maybeSizeCall instanceof J.MethodInvocation) {
                        J.MethodInvocation maybeSizeCallMethod = (J.MethodInvocation)maybeSizeCall;
                        if (COLLECTION_SIZE.matches((MethodCall)maybeSizeCallMethod) && maybeSizeCallMethod.getMethodType() != null) {
                            return this.newIsEmptyCall(maybeSizeCallMethod, binary.getCoordinates().replace(), binary.getOperator() == J.Binary.Type.GreaterThanOrEqual || binary.getOperator() == J.Binary.Type.LessThanOrEqual).withPrefix(binary.getPrefix());
                        }
                    }
                }
                return super.visitBinary(binary, (Object)ctx);
            }

            private J newIsEmptyCall(J.MethodInvocation method, JavaCoordinates coordinates, boolean negate) {
                JavaTemplate isEmpty = JavaTemplate.builder((String)"#{}#{any(java.util.Collection)}.isEmpty()").build();
                if (method.getSelect() == null) {
                    assert (method.getMethodType() != null);
                    J.Identifier this_ = JavaElementFactory.newThis((JavaType)method.getMethodType().getDeclaringType());
                    J isEmptyCall = isEmpty.apply(this.getCursor(), coordinates, new Object[]{negate ? "!" : "", this_});
                    if (negate) {
                        return ((J.Unary)isEmptyCall).withExpression((Expression)((J.MethodInvocation)((J.Unary)isEmptyCall).getExpression()).withSelect(null));
                    }
                    return ((J.MethodInvocation)isEmptyCall).withSelect(null);
                }
                return isEmpty.apply(this.getCursor(), coordinates, new Object[]{negate ? "!" : "", method.getSelect()});
            }
        });
    }

    private static boolean isZero(Expression expression) {
        return expression instanceof J.Literal && Objects.equals(0, ((J.Literal)expression).getValue());
    }

    private static boolean isOne(Expression expression) {
        return expression instanceof J.Literal && Objects.equals(1, ((J.Literal)expression).getValue());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

