/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class FixStringFormatExpressions
extends Recipe {
    private static final Pattern FS_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("(?<!\\\\)\\n");
    private static final Pattern ESCAPED_NEWLINE_PATTERN = Pattern.compile("(?<!\\\\)\\\\n");
    private static final MethodMatcher FORMAT_MATCHER = new MethodMatcher("java.lang.String format(..)");
    private static final MethodMatcher FORMATTED_MATCHER = new MethodMatcher("java.lang.String formatted(..)");
    final String displayName = "Fix `String#format` and `String#formatted` expressions";
    final String description = "Fix `String#format` and `String#formatted` expressions by replacing `\\n` newline characters with `%n` and removing any unused arguments. Note this recipe is scoped to only transform format expressions which do not specify the argument index.";
    final Set<String> tags = Collections.singleton("RSPEC-S3457");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(FORMAT_MATCHER), new UsesMethod(FORMATTED_MATCHER)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (FORMAT_MATCHER.matches((MethodCall)mi) || FORMATTED_MATCHER.matches((MethodCall)mi)) {
                    int argIndex;
                    boolean isStringFormattedExpression = false;
                    J.Literal fmtArg = null;
                    if (FORMAT_MATCHER.matches((MethodCall)mi) && mi.getArguments().get(0) instanceof J.Literal) {
                        fmtArg = (J.Literal)mi.getArguments().get(0);
                    } else if (FORMATTED_MATCHER.matches((MethodCall)mi) && mi.getSelect() instanceof J.Literal) {
                        fmtArg = (J.Literal)mi.getSelect();
                        isStringFormattedExpression = true;
                    }
                    if (fmtArg == null || fmtArg.getValue() == null || fmtArg.getValueSource() == null) {
                        return mi;
                    }
                    mi = isStringFormattedExpression ? mi.withSelect(this.replaceNewLineChars(mi.getSelect())) : mi.withArguments(ListUtils.mapFirst((List)mi.getArguments(), this::replaceNewLineChars));
                    String val = (String)fmtArg.getValue();
                    Matcher m = FS_PATTERN.matcher(val);
                    int n = argIndex = isStringFormattedExpression ? 0 : 1;
                    while (m.find()) {
                        if (m.group(1) != null || m.group(2).contains("<")) {
                            return mi;
                        }
                        ++argIndex;
                    }
                    int finalArgIndex = argIndex;
                    return mi.withArguments(ListUtils.map((List)mi.getArguments(), (i, arg) -> {
                        if (i == 0 || i < finalArgIndex) {
                            return arg;
                        }
                        return null;
                    }));
                }
                return mi;
            }

            private Expression replaceNewLineChars(Expression arg0) {
                if (arg0 instanceof J.Literal) {
                    J.Literal fmt = (J.Literal)arg0;
                    if (fmt.getValue() != null) {
                        fmt = fmt.withValue((Object)NEWLINE_PATTERN.matcher(fmt.getValue().toString()).replaceAll("%n"));
                    }
                    if (fmt.getValueSource() != null) {
                        fmt = fmt.withValueSource(ESCAPED_NEWLINE_PATTERN.matcher(fmt.getValueSource()).replaceAll("%n"));
                    }
                    return fmt;
                }
                return arg0;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

