/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class ExternalizableHasNoArgsConstructor
extends Recipe {
    private static final JavaType EXTERNALIZABLE_TYPE = JavaType.buildType((String)"java.io.Externalizable");
    final String displayName = "`Externalizable` classes have no-arguments constructor";
    final String description = "`Externalizable` classes handle both serialization and deserialization and must have a no-args constructor for the deserialization process.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(20L);
    final Set<String> tags = Collections.singleton("RSPEC-S2060");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("java.io.Externalizable", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (TypeUtils.isAssignableTo((JavaType)EXTERNALIZABLE_TYPE, (JavaType)cd.getType())) {
                    boolean hasFinalUninitializedFieldVar = false;
                    Integer firstMethodDeclarationIndex = null;
                    List statements = cd.getBody().getStatements();
                    for (int i = 0; i < statements.size(); ++i) {
                        J.VariableDeclarations varDecls;
                        Statement statement = (Statement)statements.get(i);
                        if (statement instanceof J.VariableDeclarations && J.Modifier.hasModifier((Collection)(varDecls = (J.VariableDeclarations)statement).getModifiers(), (J.Modifier.Type)J.Modifier.Type.Final) && varDecls.getVariables().stream().anyMatch(v -> v.getInitializer() == null)) {
                            hasFinalUninitializedFieldVar = true;
                            break;
                        }
                        if (!(statement instanceof J.MethodDeclaration) || firstMethodDeclarationIndex != null) continue;
                        firstMethodDeclarationIndex = i;
                    }
                    if (!hasFinalUninitializedFieldVar && !this.hasNoArgsConstructor(cd) && this.parentClassHasNoArgsConstructor(cd)) {
                        cd = (J.ClassDeclaration)JavaTemplate.builder((String)("public " + cd.getSimpleName() + "() {}")).contextSensitive().build().apply(this.updateCursor((Tree)cd), cd.getBody().getCoordinates().lastStatement(), new Object[0]);
                        if (firstMethodDeclarationIndex != null) {
                            statements.add(firstMethodDeclarationIndex, (Statement)cd.getBody().getStatements().remove(cd.getBody().getStatements().size() - 1));
                            cd = cd.withBody(cd.getBody().withStatements(statements));
                        }
                    }
                }
                return cd;
            }

            private boolean hasNoArgsConstructor(J.ClassDeclaration cd) {
                boolean hasNoArgsConstructor = false;
                boolean hasDefaultConstructor = true;
                for (Statement statement : cd.getBody().getStatements()) {
                    J.MethodDeclaration md;
                    if (!(statement instanceof J.MethodDeclaration) || !(md = (J.MethodDeclaration)statement).isConstructor()) continue;
                    if (md.getParameters().isEmpty() || md.getParameters().get(0) instanceof J.Empty) {
                        hasNoArgsConstructor = true;
                        continue;
                    }
                    hasDefaultConstructor = false;
                }
                return hasDefaultConstructor || hasNoArgsConstructor;
            }

            private boolean parentClassHasNoArgsConstructor(J.ClassDeclaration cd) {
                if (cd.getExtends() == null) {
                    return true;
                }
                JavaType.FullyQualified parentFq = TypeUtils.asFullyQualified((JavaType)cd.getExtends().getType());
                if (parentFq == null) {
                    return false;
                }
                boolean hasNoArgsConstructor = false;
                boolean hasDefaultConstructor = true;
                for (JavaType.Method method : parentFq.getMethods()) {
                    if (!"<constructor>".equals(method.getName())) continue;
                    if (method.getParameterNames().isEmpty()) {
                        hasNoArgsConstructor = true;
                        continue;
                    }
                    hasDefaultConstructor = false;
                }
                return hasDefaultConstructor || hasNoArgsConstructor;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

