/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.staticanalysis.ExplicitInitializationVisitor;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public class ExplicitInitialization
extends Recipe {
    final String displayName = "Explicit initialization";
    final String description = "Checks if any class or object member is explicitly initialized to default for its type value:\n - `null` for object references\n - zero for numeric types and `char`\n - and `false` for `boolean`\nRemoves explicit initializations where they aren't necessary.";
    final Set<String> tags = Collections.singleton("RSPEC-S3052");
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not(new KotlinFileChecker()), new ExplicitInitializationVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

