/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class ExplicitCharsetOnStringGetBytes
extends Recipe {
    private static final MethodMatcher GET_BYTES = new MethodMatcher("java.lang.String getBytes()");
    @Option(displayName="Default encoding", description="The default encoding to supply to the `getBytes` call", example="UTF_8", required=false)
    private final @Nullable String encoding;
    private final String displayName = "Set charset encoding explicitly when calling `String#getBytes`";
    private final String description = "This makes the behavior of the code platform neutral. It will not override any existing explicit encodings, even if they don't match the default encoding option.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(GET_BYTES), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final JavaTemplate WITH_ENCODING = JavaTemplate.builder((String)"getBytes(StandardCharsets.#{})").contextSensitive().imports(new String[]{"java.nio.charset.StandardCharsets"}).build();

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (GET_BYTES.matches((MethodCall)method)) {
                    this.maybeAddImport("java.nio.charset.StandardCharsets");
                    m = (J.MethodInvocation)this.WITH_ENCODING.apply(this.updateCursor((Tree)m), m.getCoordinates().replaceMethod(), new Object[]{ExplicitCharsetOnStringGetBytes.this.encoding == null ? "UTF_8" : ExplicitCharsetOnStringGetBytes.this.encoding});
                }
                return m;
            }
        });
    }

    @Generated
    public ExplicitCharsetOnStringGetBytes(@Nullable String encoding) {
        this.encoding = encoding;
    }

    @Generated
    public @Nullable String getEncoding() {
        return this.encoding;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "ExplicitCharsetOnStringGetBytes(encoding=" + this.getEncoding() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExplicitCharsetOnStringGetBytes)) {
            return false;
        }
        ExplicitCharsetOnStringGetBytes other = (ExplicitCharsetOnStringGetBytes)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$encoding = this.getEncoding();
        String other$encoding = other.getEncoding();
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExplicitCharsetOnStringGetBytes;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

