/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class CollectionToArrayShouldHaveProperType
extends Recipe {
    private static final MethodMatcher TO_ARRAY = new MethodMatcher("java.util.Collection toArray()", true);
    final String displayName = "'Collection.toArray()' should be passed an array of the proper type";
    final String description = "Using `Collection.toArray()` without parameters returns an `Object[]`, which requires casting. It is more efficient and clearer to use `Collection.toArray(new T[0])` instead.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);
    final Set<String> tags = Collections.singleton("RSPEC-S3020");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public <T extends J> J visitParentheses(J.Parentheses<T> parentheses, ExecutionContext ctx) {
                J.TypeCast typeCast;
                Expression expression;
                J.Parentheses visitedParentheses;
                J visited = super.visitParentheses(parentheses, (Object)ctx);
                if (visited instanceof J.Parentheses && (visitedParentheses = (J.Parentheses)visited).getTree() instanceof J.TypeCast && (expression = (typeCast = (J.TypeCast)visitedParentheses.getTree()).getExpression()) instanceof J.MethodInvocation) {
                    JavaType componentType;
                    JavaType.FullyQualified fqType;
                    JavaType targetType;
                    JavaType.Array arrayType;
                    J.MethodInvocation methodInvocation = (J.MethodInvocation)expression;
                    if (TO_ARRAY.matches((MethodCall)methodInvocation) && (arrayType = TypeUtils.asArray((JavaType)(targetType = typeCast.getType()))) != null && (fqType = TypeUtils.asFullyQualified((JavaType)(componentType = arrayType.getElemType()))) != null) {
                        String className = fqType.getClassName();
                        String fqn = fqType.getFullyQualifiedName();
                        JavaTemplate template = JavaTemplate.builder((String)"#{any()}.toArray(new #{}[0])").imports(new String[]{fqn}).build();
                        Expression result = (Expression)template.apply(this.getCursor(), visitedParentheses.getCoordinates().replace(), new Object[]{Objects.requireNonNull(methodInvocation.getSelect()), className});
                        this.maybeAddImport(fqn);
                        return visitedParentheses.withTree((J)result);
                    }
                }
                return visited;
            }

            public J visitTypeCast(J.TypeCast typeCast, ExecutionContext ctx) {
                J visited = super.visitTypeCast(typeCast, (Object)ctx);
                if (!(visited instanceof J.TypeCast)) {
                    return visited;
                }
                J.TypeCast visitedTypeCast = (J.TypeCast)visited;
                Expression expression = visitedTypeCast.getExpression();
                if (expression instanceof J.MethodInvocation) {
                    JavaType componentType;
                    JavaType.FullyQualified fqType;
                    JavaType targetType;
                    JavaType.Array arrayType;
                    J.MethodInvocation methodInvocation = (J.MethodInvocation)expression;
                    if (TO_ARRAY.matches((MethodCall)methodInvocation) && (arrayType = TypeUtils.asArray((JavaType)(targetType = visitedTypeCast.getType()))) != null && (fqType = TypeUtils.asFullyQualified((JavaType)(componentType = arrayType.getElemType()))) != null) {
                        String className = fqType.getClassName();
                        String fqn = fqType.getFullyQualifiedName();
                        JavaTemplate template = JavaTemplate.builder((String)"#{any()}.toArray(new #{}[0])").imports(new String[]{fqn}).build();
                        Expression result = (Expression)template.apply(this.getCursor(), visitedTypeCast.getCoordinates().replace(), new Object[]{Objects.requireNonNull(methodInvocation.getSelect()), className});
                        this.maybeAddImport(fqn);
                        return result;
                    }
                }
                return visitedTypeCast;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

