/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class UsePortableNewlines
extends Recipe {
    private static final MethodMatcher STRING_FORMATTED = new MethodMatcher("java.lang.String formatted(..)");
    private static final MethodMatcher STRING_FORMAT = new MethodMatcher("java.lang.String format(java.lang.String, ..)");
    private static final MethodMatcher PRINT_STREAM_PRINTF = new MethodMatcher("java.io.PrintStream printf(java.lang.String, ..)");
    private static final MethodMatcher PRINT_WRITER_PRINTF = new MethodMatcher("java.io.PrintWriter printf(java.lang.String, ..)");
    private static final MethodMatcher FORMATTER_FORMAT = new MethodMatcher("java.util.Formatter format(java.lang.String, ..)");
    private static final MethodMatcher CONSOLE_PRINTF = new MethodMatcher("java.io.Console printf(java.lang.String, ..)");

    public String getDisplayName() {
        return "Use %n instead of \\n in format strings";
    }

    public String getDescription() {
        return "Format strings should use %n rather than \\n to produce platform-specific line separators.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S3457");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(STRING_FORMATTED), new UsesMethod(STRING_FORMAT), new UsesMethod(PRINT_STREAM_PRINTF), new UsesMethod(PRINT_WRITER_PRINTF), new UsesMethod(FORMATTER_FORMAT), new UsesMethod(CONSOLE_PRINTF)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (STRING_FORMATTED.matches((MethodCall)method) && method.getSelect() != null) {
                    return method.withSelect(UsePortableNewlines.replaceNewlineInLiteral(method.getSelect()));
                }
                if (STRING_FORMAT.matches((MethodCall)method) || PRINT_STREAM_PRINTF.matches((MethodCall)method) || PRINT_WRITER_PRINTF.matches((MethodCall)method) || FORMATTER_FORMAT.matches((MethodCall)method) || CONSOLE_PRINTF.matches((MethodCall)method)) {
                    return method.withArguments(ListUtils.mapFirst((List)method.getArguments(), x$0 -> UsePortableNewlines.replaceNewlineInLiteral(x$0)));
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    private static Expression replaceNewlineInLiteral(Expression maybeLiteral) {
        J.Literal literal;
        if (maybeLiteral instanceof J.Literal && (literal = (J.Literal)maybeLiteral).getValue() instanceof String && literal.getValueSource() != null) {
            String source = literal.getValueSource();
            String value = (String)literal.getValue();
            if (source.contains("\\n")) {
                return literal.withValue((Object)value.replace("\n", "%n")).withValueSource(source.replace("\\n", "%n"));
            }
        }
        return maybeLiteral;
    }

    @Generated
    public UsePortableNewlines() {
    }

    @Generated
    public String toString() {
        return "UsePortableNewlines()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UsePortableNewlines)) {
            return false;
        }
        UsePortableNewlines other = (UsePortableNewlines)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UsePortableNewlines;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

