/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class ReorderAnnotationAttributes
extends Recipe {
    private static final Comparator<Expression> attributeComparator = (e1, e2) -> {
        if (e1 instanceof J.Assignment && e2 instanceof J.Assignment) {
            J.Assignment a1 = (J.Assignment)e1;
            J.Assignment a2 = (J.Assignment)e2;
            if (a1.getVariable() instanceof J.Identifier && a2.getVariable() instanceof J.Identifier) {
                String name1 = ((J.Identifier)a1.getVariable()).getSimpleName();
                String name2 = ((J.Identifier)a2.getVariable()).getSimpleName();
                return name1.compareTo(name2);
            }
        }
        return 0;
    };

    public String getDisplayName() {
        return "Reorder annotation attributes alphabetically";
    }

    public String getDescription() {
        return "Reorder annotation attributes to be alphabetical. Positional arguments (those without explicit attribute names) are left in their original position.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Annotated.Matcher("*..*").asVisitor(annotated -> {
            J.Annotation a = (J.Annotation)annotated.getTree();
            List arguments = a.getArguments();
            if (arguments == null || arguments.size() <= 1 || !arguments.stream().allMatch(e -> e instanceof J.Assignment)) {
                return a;
            }
            ArrayList<Expression> sortedNamed = new ArrayList<Expression>(arguments);
            sortedNamed.sort(attributeComparator);
            if (!sortedNamed.equals(arguments)) {
                return a.withArguments(ListUtils.map(sortedNamed, (i, arg) -> (Expression)arg.withPrefix(arg.getPrefix().withWhitespace(((Expression)arguments.get((int)i)).getPrefix().getWhitespace()))));
            }
            return a;
        });
    }

    @Generated
    public ReorderAnnotationAttributes() {
    }

    @Generated
    public String toString() {
        return "ReorderAnnotationAttributes()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReorderAnnotationAttributes)) {
            return false;
        }
        ReorderAnnotationAttributes other = (ReorderAnnotationAttributes)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReorderAnnotationAttributes;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

