/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class SimplifyConsecutiveAssignments
extends Recipe {
    public String getDisplayName() {
        return "Simplify consecutive assignments";
    }

    public String getDescription() {
        return "Combine consecutive assignments into a single statement where possible.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final JavaTemplate combinedAssignment = JavaTemplate.builder((String)"o = (#{any()} #{} #{any()});").build();

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block b2;
                AtomicInteger skip;
                J.Block b;
                J.Block combined = b = super.visitBlock(block, (Object)ctx);
                do {
                    b = combined;
                    this.updateCursor((Tree)b);
                    b2 = b;
                    skip = new AtomicInteger(-1);
                } while ((combined = b.withStatements(ListUtils.map((List)b.getStatements(), (i, stat) -> {
                    if (skip.get() == i.intValue()) {
                        return null;
                    }
                    String name = this.numericVariableName((Statement)stat);
                    if (name != null && i < b2.getStatements().size() - 1) {
                        Statement nextStatement = (Statement)b2.getStatements().get(i + 1);
                        Expression acc = this.numericVariableAccumulation(nextStatement, name);
                        String op = this.numericVariableOperator(nextStatement, name);
                        if (acc != null && op != null) {
                            skip.set(i + 1);
                            return this.combine(new Cursor(this.getCursor(), stat), op, acc);
                        }
                    }
                    return stat;
                }))) != b);
                if (b != block) {
                    b = (J.Block)new UnnecessaryParenthesesVisitor().visitNonNull((Tree)b, (Object)ctx, this.getCursor().getParentOrThrow());
                }
                return b;
            }

            private @Nullable String numericVariableName(Statement s) {
                if (s instanceof J.Assignment) {
                    return this.singleVariableName(((J.Assignment)s).getVariable());
                }
                if (s instanceof J.VariableDeclarations) {
                    J.VariableDeclarations.NamedVariable firstNamedVariable = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)s).getVariables().get(0);
                    return firstNamedVariable.getInitializer() == null ? null : this.singleVariableName((Expression)firstNamedVariable.getName());
                }
                return null;
            }

            private @Nullable Expression numericVariableAccumulation(Statement s, String name) {
                J.AssignmentOperation assignOp;
                if (!s.getPrefix().getComments().isEmpty()) {
                    return null;
                }
                if (s instanceof J.Unary) {
                    if (name.equals(this.singleVariableName(((J.Unary)s).getExpression()))) {
                        return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)1, "1", null, JavaType.Primitive.Int);
                    }
                } else if (s instanceof J.AssignmentOperation && name.equals(this.singleVariableName((assignOp = (J.AssignmentOperation)s).getVariable()))) {
                    return assignOp.getAssignment();
                }
                return null;
            }

            private @Nullable String numericVariableOperator(Statement s, String name) {
                J.AssignmentOperation assignOp;
                if (s instanceof J.Unary) {
                    if (name.equals(this.singleVariableName(((J.Unary)s).getExpression()))) {
                        switch (((J.Unary)s).getOperator()) {
                            case PreDecrement: 
                            case PostDecrement: {
                                return "-";
                            }
                            case PreIncrement: 
                            case PostIncrement: {
                                return "+";
                            }
                        }
                    }
                } else if (s instanceof J.AssignmentOperation && name.equals(this.singleVariableName((assignOp = (J.AssignmentOperation)s).getVariable()))) {
                    switch (assignOp.getOperator()) {
                        case Addition: {
                            return "+";
                        }
                        case BitAnd: {
                            return "&";
                        }
                        case BitOr: {
                            return "|";
                        }
                        case BitXor: {
                            return "^";
                        }
                        case Division: {
                            return "/";
                        }
                        case LeftShift: {
                            return "<<";
                        }
                        case Modulo: {
                            return "%";
                        }
                        case Multiplication: {
                            return "*";
                        }
                        case RightShift: {
                            return ">>";
                        }
                        case Subtraction: {
                            return "-";
                        }
                        case UnsignedRightShift: {
                            return ">>>";
                        }
                    }
                }
                return null;
            }

            private @Nullable String singleVariableName(Expression e) {
                JavaType.Primitive type = TypeUtils.asPrimitive((JavaType)e.getType());
                return type != null && type.isNumeric() && e instanceof J.Identifier ? ((J.Identifier)e).getSimpleName() : null;
            }

            private Statement combine(Cursor cursor, String op, Expression right) {
                Statement s = (Statement)cursor.getValue();
                if (s instanceof J.Assignment) {
                    J.Assignment assign = (J.Assignment)s;
                    J.Assignment after = (J.Assignment)this.combinedAssignment.apply(cursor, s.getCoordinates().replace(), new Object[]{assign.getAssignment(), op, right});
                    return assign.withAssignment(after.getAssignment());
                }
                if (s instanceof J.VariableDeclarations) {
                    J.VariableDeclarations variables = (J.VariableDeclarations)s;
                    J.Assignment after = (J.Assignment)this.combinedAssignment.apply(cursor, s.getCoordinates().replace(), new Object[]{((J.VariableDeclarations.NamedVariable)variables.getVariables().get(0)).getInitializer(), op, right});
                    return variables.withVariables(ListUtils.map((List)variables.getVariables(), (i, namedVar) -> i == 0 ? namedVar.withInitializer(after.getAssignment()) : namedVar));
                }
                throw new UnsupportedOperationException("Attempted to combine assignments into a single statement with type " + s.getClass().getSimpleName());
            }
        };
    }
}

