/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class SimplifyArraysAsList
extends Recipe {
    private static final MethodMatcher ARRAYS_AS_LIST = new MethodMatcher("java.util.Arrays asList(..)");

    public String getDisplayName() {
        return "Simplify `Arrays.asList(..)` with varargs";
    }

    public String getDescription() {
        return "Simplifies `Arrays.asList()` method calls that use explicit array creation to use varargs instead. For example, `Arrays.asList(new String[]{\"a\", \"b\", \"c\"})` becomes `Arrays.asList(\"a\", \"b\", \"c\")`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S3878");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ARRAYS_AS_LIST), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (ARRAYS_AS_LIST.matches((MethodCall)mi) && mi.getArguments().size() == 1 && mi.getArguments().get(0) instanceof J.NewArray) {
                    J.NewArray newArray = (J.NewArray)mi.getArguments().get(0);
                    List elements = newArray.getInitializer();
                    if (!(newArray.getDimensions().size() != 1 || elements == null || elements.size() == 1 && J.Literal.isLiteralValue((Expression)((Expression)elements.get(0)), null))) {
                        return mi.withArguments(newArray.getInitializer());
                    }
                }
                return mi;
            }
        });
    }
}

