/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.NeedBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.Style;

public class NeedBraces
extends Recipe {
    public String getDisplayName() {
        return "Fix missing braces";
    }

    public String getDescription() {
        return "Adds missing braces around code such as single-line `if`, `for`, `while`, and `do-while` block bodies.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S121");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new NeedBracesVisitor();
    }

    private static class NeedBracesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        NeedBracesStyle needBracesStyle;

        private NeedBracesVisitor() {
        }

        private <T extends Statement> J.Block buildBlock(T element) {
            Cursor currentCursor;
            J rootElement = null;
            Space end = Space.EMPTY;
            for (currentCursor = this.getCursor(); currentCursor != null && currentCursor.getParent() != null && !(currentCursor.getParent().getValue() instanceof J.Block); currentCursor = currentCursor.getParent()) {
            }
            if (currentCursor != null && currentCursor.getValue() instanceof JRightPadded) {
                JRightPadded paddedIf = (JRightPadded)currentCursor.getValue();
                rootElement = (J)paddedIf.getElement();
            }
            if (rootElement instanceof Statement && !(rootElement instanceof J.DoWhileLoop)) {
                Space trailingComment;
                Cursor blockParentCursor = currentCursor.getParent();
                J.Block block = (J.Block)blockParentCursor.getValue();
                List statements = block.getStatements();
                int currentIndex = statements.indexOf(rootElement);
                boolean last = currentIndex == statements.size() - 1;
                Space space = trailingComment = last ? block.getEnd() : ((Statement)statements.get(currentIndex + 1)).getPrefix();
                if (!trailingComment.isEmpty() && !trailingComment.getWhitespace().contains("\n")) {
                    end = trailingComment;
                    if (last) {
                        blockParentCursor.putMessage("removeEndComments", (Object)true);
                    } else {
                        ((List)blockParentCursor.computeMessageIfAbsent("replaced", k -> new ArrayList())).add(currentIndex);
                    }
                }
            }
            return new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)false), element instanceof J.Empty ? Collections.emptyList() : Collections.singletonList(JRightPadded.build(element)), end);
        }

        public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof SourceFile) {
                SourceFile cu = (SourceFile)Objects.requireNonNull(tree);
                if (cu.getSourcePath().toString().endsWith(".py")) {
                    return (J)tree;
                }
                this.needBracesStyle = cu.getStyle(NeedBracesStyle.class) == null ? Checkstyle.needBracesStyle() : (NeedBracesStyle)cu.getStyle(NeedBracesStyle.class, (Style)new NeedBracesStyle(Boolean.valueOf(false), Boolean.valueOf(false)));
            }
            return (J)super.visit(tree, (Object)ctx);
        }

        public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
            List indexes;
            J.Block bl = super.visitBlock(block, (Object)ctx);
            if (Boolean.TRUE.equals(this.getCursor().pollMessage("removeEndComments"))) {
                bl = bl.withEnd(bl.getEnd().withComments(Collections.emptyList()));
                bl = (J.Block)this.maybeAutoFormat((J)block, (J)bl, ctx);
            }
            if ((indexes = (List)this.getCursor().pollMessage("replaced")) != null) {
                Iterator iterator = indexes.iterator();
                while (iterator.hasNext()) {
                    boolean last;
                    int index = (Integer)iterator.next();
                    boolean bl2 = last = index == bl.getPadding().getStatements().size() - 1;
                    if (!last) {
                        bl = bl.withStatements(ListUtils.map((List)bl.getStatements(), (i, stmt) -> {
                            if (i == index + 1) {
                                return (Statement)stmt.withPrefix(Space.EMPTY);
                            }
                            return stmt;
                        }));
                        continue;
                    }
                    bl = bl.withEnd(bl.getEnd().withComments(Collections.emptyList()));
                }
                bl = (J.Block)this.maybeAutoFormat((J)block, (J)bl, ctx);
            }
            return bl;
        }

        public J.If visitIf(J.If iff, ExecutionContext ctx) {
            if (this.usedAsExpression()) {
                return iff;
            }
            J.If elem = super.visitIf(iff, (Object)ctx);
            boolean hasAllowableBodyType = elem.getThenPart() instanceof J.Block;
            if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b;
                if (elem.getElsePart() != null && !elem.getElsePart().getPrefix().getComments().isEmpty()) {
                    Space end = elem.getElsePart().getPrefix();
                    elem = elem.withElsePart(elem.getElsePart().withPrefix(Space.EMPTY));
                    b = this.buildBlock(elem.getThenPart()).withEnd(end);
                } else {
                    b = this.buildBlock(elem.getThenPart());
                }
                elem = (J.If)this.maybeAutoFormat((J)elem, (J)elem.withThenPart((Statement)b), ctx);
            }
            return elem;
        }

        private boolean usedAsExpression() {
            return this.getCursor().getParentOrThrow().getValue() instanceof K.StatementExpression;
        }

        public J.If.Else visitElse(J.If.Else else_, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J.If.Else elem = super.visitElse(else_, (Object)ctx);
            boolean bl = hasAllowableBodyType = elem.getBody() instanceof J.Block || elem.getBody() instanceof J.If;
            if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                Space prefix = elem.getPrefix();
                Statement body = elem.getBody();
                if (!prefix.getComments().isEmpty() && prefix.getWhitespace().contains("\n")) {
                    body = (Statement)body.withPrefix(prefix);
                }
                J.Block b = this.buildBlock(body);
                elem = (J.If.Else)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            }
            return elem;
        }

        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J.WhileLoop elem = super.visitWhileLoop(whileLoop, (Object)ctx);
            boolean bl = this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() ? elem.getBody() instanceof J.Block || elem.getBody() instanceof J.Empty : (hasAllowableBodyType = elem.getBody() instanceof J.Block);
            if (!this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() && elem.getBody() instanceof J.Empty) {
                J.Block b = this.buildBlock(elem.getBody());
                elem = (J.WhileLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            } else if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = this.buildBlock(elem.getBody());
                elem = (J.WhileLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            }
            return elem;
        }

        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J.DoWhileLoop elem = super.visitDoWhileLoop(doWhileLoop, (Object)ctx);
            boolean bl = this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() ? elem.getBody() instanceof J.Block || elem.getBody() instanceof J.Empty : (hasAllowableBodyType = elem.getBody() instanceof J.Block);
            if (!this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() && elem.getBody() instanceof J.Empty) {
                J.Block b = this.buildBlock(elem.getBody());
                elem = (J.DoWhileLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            } else if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = this.buildBlock(elem.getBody());
                elem = (J.DoWhileLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            }
            return elem;
        }

        public J.ForLoop visitForLoop(J.ForLoop forLoop, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J.ForLoop elem = super.visitForLoop(forLoop, (Object)ctx);
            boolean bl = this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() ? elem.getBody() instanceof J.Block || elem.getBody() instanceof J.Empty : (hasAllowableBodyType = elem.getBody() instanceof J.Block);
            if (!this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() && elem.getBody() instanceof J.Empty) {
                J.Block b = this.buildBlock(elem.getBody());
                elem = (J.ForLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            } else if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = this.buildBlock(elem.getBody());
                elem = (J.ForLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            }
            return elem;
        }
    }
}

