/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.ShortenFullyQualifiedTypeReferences;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.staticanalysis.java.MoveFieldAnnotationToType;

public final class AnnotateNullableParameters
extends Recipe {
    private static final String DEFAULT_NULLABLE_ANN_CLASS = "org.jspecify.annotations.Nullable";
    private static final List<MethodMatcher> NULL_SAFETY_METHOD_MATCHERS = Arrays.asList(new MethodMatcher("com.google.common.base.Strings isNullOrEmpty(..)"), new MethodMatcher("java.util.Objects isNull(..)"), new MethodMatcher("java.util.Objects nonNull(..)"), new MethodMatcher("org.apache.commons.lang3.StringUtils isBlank(..)"), new MethodMatcher("org.apache.commons.lang3.StringUtils isEmpty(..)"), new MethodMatcher("org.apache.commons.lang3.StringUtils isNotBlank(..)"), new MethodMatcher("org.apache.commons.lang3.StringUtils isNotEmpty(..)"), new MethodMatcher("org.springframework.util.ObjectUtils hasText(..)"), new MethodMatcher("org.springframework.util.StringUtils isEmpty(..)"), new MethodMatcher("org.springframework.util.StringUtils hasLength(..)"), new MethodMatcher("org.springframework.util.StringUtils hasText(..)"));
    @Option(displayName="`@Nullable` annotation class", description="The fully qualified name of the @Nullable annotation. The annotation should be meta annotated with `@Target(TYPE_USE)`. Defaults to `org.jspecify.annotations.Nullable`", example="org.jspecify.annotations.Nullable", required=false)
    private final @Nullable String nullableAnnotationClass;

    public String getDisplayName() {
        return "Annotate null-checked method parameters with `@Nullable`";
    }

    public String getDescription() {
        return "Add `@Nullable` to parameters of public methods that are explicitly checked for `null`. By default `org.jspecify.annotations.Nullable` is used, but through the `nullableAnnotationClass` option a custom annotation can be provided. When providing a custom `nullableAnnotationClass` that annotation should be meta annotated with `@Target(TYPE_USE)`. This recipe scans for methods that do not already have parameters annotated with `@Nullable` annotation and checks their usages for potential null checks.";
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"nullableAnnotationClass", (String)"Property `nullableAnnotationClass` must be a fully qualified classname.", (Object)this.nullableAnnotationClass, it -> it == null || it.contains(".")));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String fullyQualifiedName = this.nullableAnnotationClass != null ? this.nullableAnnotationClass : DEFAULT_NULLABLE_ANN_CLASS;
        final String fullyQualifiedPackage = fullyQualifiedName.substring(0, fullyQualifiedName.lastIndexOf(46));
        final String simpleName = fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46) + 1);
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(methodDeclaration, (Object)ctx);
                if (!md.hasModifier(J.Modifier.Type.Public) || md.getBody() == null || md.getParameters().isEmpty() || md.getParameters().get(0) instanceof J.Empty || md.getMethodType() == null || md.getMethodType().isOverride()) {
                    return md;
                }
                Map candidateIdentifiers = AnnotateNullableParameters.this.buildIdentifierMap(AnnotateNullableParameters.this.findCandidateParameters(md, fullyQualifiedName));
                Set nullCheckedIdentifiers = (Set)new NullCheckVisitor(candidateIdentifiers.values()).reduce((Tree)md.getBody(), new HashSet());
                this.maybeAddImport(fullyQualifiedName);
                return md.withParameters(ListUtils.map((List)md.getParameters(), stm -> {
                    J.VariableDeclarations vd;
                    if (stm instanceof J.VariableDeclarations && AnnotateNullableParameters.containsIdentifierByName(nullCheckedIdentifiers, (J.Identifier)candidateIdentifiers.get(vd = (J.VariableDeclarations)stm))) {
                        J.VariableDeclarations annotated = (J.VariableDeclarations)JavaTemplate.builder((String)("@" + fullyQualifiedName)).javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{String.format("package %s;public @interface %s {}", fullyQualifiedPackage, simpleName)})).build().apply(new Cursor(this.getCursor(), (Object)vd), vd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                        this.doAfterVisit((TreeVisitor)ShortenFullyQualifiedTypeReferences.modifyOnly((J)annotated));
                        this.doAfterVisit(new MoveFieldAnnotationToType(fullyQualifiedName).getVisitor());
                        return annotated.withModifiers(ListUtils.mapFirst((List)annotated.getModifiers(), first -> first.withPrefix(Space.SINGLE_SPACE)));
                    }
                    return stm;
                }));
            }
        };
    }

    private static boolean containsIdentifierByName(Collection<J.Identifier> identifiers, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable J.Identifier target) {
        if (target == null) {
            return false;
        }
        return identifiers.stream().anyMatch(identifier -> SemanticallyEqual.areEqual((J)identifier, (J)target));
    }

    private List<J.VariableDeclarations> findCandidateParameters(J.MethodDeclaration md, String fqn) {
        ArrayList<J.VariableDeclarations> candidates = new ArrayList<J.VariableDeclarations>();
        for (Statement parameter : md.getParameters()) {
            J.VariableDeclarations vd;
            if (!(parameter instanceof J.VariableDeclarations) || !FindAnnotations.find((J)(vd = (J.VariableDeclarations)parameter), (String)("@" + fqn)).isEmpty()) continue;
            candidates.add(vd);
        }
        return candidates;
    }

    private Map<J.VariableDeclarations, J.Identifier> buildIdentifierMap(List<J.VariableDeclarations> parameters) {
        HashMap<J.VariableDeclarations, J.Identifier> identifierMap = new HashMap<J.VariableDeclarations, J.Identifier>();
        for (J.VariableDeclarations vd : parameters) {
            vd.getVariables().stream().map(J.VariableDeclarations.NamedVariable::getName).findFirst().ifPresent(identifier -> identifierMap.put(vd, (J.Identifier)identifier));
        }
        return identifierMap;
    }

    @Generated
    public AnnotateNullableParameters(@Nullable String nullableAnnotationClass) {
        this.nullableAnnotationClass = nullableAnnotationClass;
    }

    @Generated
    public @Nullable String getNullableAnnotationClass() {
        return this.nullableAnnotationClass;
    }

    @Generated
    public String toString() {
        return "AnnotateNullableParameters(nullableAnnotationClass=" + this.getNullableAnnotationClass() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotateNullableParameters)) {
            return false;
        }
        AnnotateNullableParameters other = (AnnotateNullableParameters)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$nullableAnnotationClass = this.getNullableAnnotationClass();
        String other$nullableAnnotationClass = other.getNullableAnnotationClass();
        return !(this$nullableAnnotationClass == null ? other$nullableAnnotationClass != null : !this$nullableAnnotationClass.equals(other$nullableAnnotationClass));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnnotateNullableParameters;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nullableAnnotationClass = this.getNullableAnnotationClass();
        result = result * 59 + ($nullableAnnotationClass == null ? 43 : $nullableAnnotationClass.hashCode());
        return result;
    }

    private static class NullCheckVisitor
    extends JavaIsoVisitor<Set<J.Identifier>> {
        private final Collection<J.Identifier> identifiers;

        public J.If visitIf(J.If iff, Set<J.Identifier> nullCheckedParams) {
            iff = super.visitIf(iff, nullCheckedParams);
            this.handleCondition((Expression)iff.getIfCondition().getTree(), nullCheckedParams);
            return iff;
        }

        private void handleCondition(Expression condition, Set<J.Identifier> nullCheckedParams) {
            if (condition instanceof J.Binary) {
                this.handleBinary((J.Binary)condition, nullCheckedParams);
            } else if (condition instanceof J.MethodInvocation) {
                this.handleMethodInvocation((J.MethodInvocation)condition, nullCheckedParams);
            } else if (condition instanceof J.Unary) {
                this.handleUnary((J.Unary)condition, nullCheckedParams);
            }
        }

        private void handleBinary(J.Binary binary, Set<J.Identifier> nullCheckedParams) {
            J.Identifier identifier;
            Expression maybeParam = null;
            if (J.Literal.isLiteralValue((Expression)binary.getLeft(), null)) {
                maybeParam = binary.getRight();
            } else if (J.Literal.isLiteralValue((Expression)binary.getRight(), null)) {
                maybeParam = binary.getLeft();
            } else {
                this.handleCondition(binary.getLeft(), nullCheckedParams);
                this.handleCondition(binary.getRight(), nullCheckedParams);
            }
            if (maybeParam instanceof J.Identifier && AnnotateNullableParameters.containsIdentifierByName(this.identifiers, identifier = (J.Identifier)maybeParam)) {
                nullCheckedParams.add((J.Identifier)maybeParam);
            }
        }

        private void handleMethodInvocation(J.MethodInvocation mi, Set<J.Identifier> nullCheckedParams) {
            if (this.isKnownNullMethodChecker(mi)) {
                new JavaIsoVisitor<Set<J.Identifier>>(){

                    public J.Identifier visitIdentifier(J.Identifier identifier, Set<J.Identifier> set) {
                        if (AnnotateNullableParameters.containsIdentifierByName(identifiers, identifier)) {
                            set.add(identifier);
                        }
                        return identifier;
                    }
                }.visit(mi.getArguments(), nullCheckedParams);
            }
        }

        private void handleUnary(J.Unary unary, Set<J.Identifier> nullCheckedParams) {
            if (unary.getExpression() instanceof J.MethodInvocation) {
                this.handleMethodInvocation((J.MethodInvocation)unary.getExpression(), nullCheckedParams);
            }
        }

        private boolean isKnownNullMethodChecker(J.MethodInvocation methodInvocation) {
            for (MethodMatcher m : NULL_SAFETY_METHOD_MATCHERS) {
                if (!m.matches((MethodCall)methodInvocation)) continue;
                return true;
            }
            return false;
        }

        @Generated
        public NullCheckVisitor(Collection<J.Identifier> identifiers) {
            this.identifiers = identifiers;
        }
    }
}

