/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class NoPrimitiveWrappersForToStringOrCompareTo
extends Recipe {
    private static final MethodMatcher NUMBER_TO_STRING_MATCHER = new MethodMatcher("java.lang.Number toString()", true);
    private static final MethodMatcher BOOLEAN_TO_STRING_MATCHER = new MethodMatcher("java.lang.Boolean toString()", true);
    private static final MethodMatcher NUMBER_COMPARE_TO_MATCHER = new MethodMatcher("java.lang.Number compareTo(..)", true);
    private static final MethodMatcher BOOLEAN_COMPARE_TO_MATCHER = new MethodMatcher("java.lang.Boolean compareTo(..)", true);

    public String getDisplayName() {
        return "No primitive wrappers for #toString() or #compareTo(..)";
    }

    public String getDescription() {
        return "Primitive wrappers should not be instantiated only for `#toString()` or `#compareTo(..)` invocations.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1158");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(NUMBER_COMPARE_TO_MATCHER), new UsesMethod(NUMBER_TO_STRING_MATCHER), new UsesMethod(BOOLEAN_COMPARE_TO_MATCHER), new UsesMethod(BOOLEAN_TO_STRING_MATCHER)}), (TreeVisitor)new NoPrimitiveWrapperVisitor());
    }

    private static class NoPrimitiveWrapperVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher VALUE_OF_NUMBER_MATCHER = new MethodMatcher("java.lang.Number valueOf(*)", true);
        private static final MethodMatcher VALUE_OF_BOOLEAN_MATCHER = new MethodMatcher("java.lang.Boolean valueOf(*)", true);

        private NoPrimitiveWrapperVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            JavaType.Class clazz;
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            JavaType.Class clazz2 = clazz = mi.getMethodType() != null ? TypeUtils.asClass((JavaType)mi.getMethodType().getDeclaringType()) : null;
            if (clazz != null && "java.lang".equals(clazz.getPackageName())) {
                if (NUMBER_TO_STRING_MATCHER.matches((MethodCall)mi) || BOOLEAN_TO_STRING_MATCHER.matches((MethodCall)mi)) {
                    J.MethodInvocation selectMethod;
                    Expression arg = null;
                    if (mi.getSelect() instanceof J.NewClass) {
                        arg = this.getSingleArg(((J.NewClass)mi.getSelect()).getArguments());
                    } else if (mi.getSelect() instanceof J.MethodInvocation && (VALUE_OF_NUMBER_MATCHER.matches((MethodCall)(selectMethod = (J.MethodInvocation)mi.getSelect())) || VALUE_OF_BOOLEAN_MATCHER.matches((MethodCall)selectMethod))) {
                        arg = this.getSingleArg(selectMethod.getArguments());
                    }
                    if (arg != null && !TypeUtils.isString((JavaType)arg.getType()) && mi.getSelect() != null) {
                        JavaType.FullyQualified fq = mi.getMethodType().getDeclaringType();
                        mi = mi.withSelect((Expression)new J.Identifier(Tree.randomId(), mi.getSelect().getPrefix(), Markers.EMPTY, Collections.emptyList(), fq.getClassName(), (JavaType)fq, null));
                        mi = mi.withArguments(Arrays.asList(arg));
                    }
                } else if (NUMBER_COMPARE_TO_MATCHER.matches((MethodCall)mi) || BOOLEAN_COMPARE_TO_MATCHER.matches((MethodCall)mi)) {
                    J.MethodInvocation selectMethod;
                    Expression arg = null;
                    if (mi.getSelect() instanceof J.NewClass) {
                        arg = this.getSingleArg(((J.NewClass)mi.getSelect()).getArguments());
                    } else if (mi.getSelect() instanceof J.MethodInvocation && (VALUE_OF_NUMBER_MATCHER.matches((MethodCall)(selectMethod = (J.MethodInvocation)mi.getSelect())) || VALUE_OF_BOOLEAN_MATCHER.matches((MethodCall)selectMethod))) {
                        arg = this.getSingleArg(selectMethod.getArguments());
                    }
                    if (arg != null && !TypeUtils.isString((JavaType)arg.getType()) && mi.getSelect() != null) {
                        JavaType.FullyQualified fq = mi.getMethodType().getDeclaringType();
                        mi = mi.withSelect((Expression)new J.Identifier(Tree.randomId(), mi.getSelect().getPrefix(), Markers.EMPTY, Collections.emptyList(), fq.getClassName(), (JavaType)fq, null));
                        mi = mi.withArguments(ListUtils.concat((Object)arg, (List)mi.getArguments()));
                        mi = (J.MethodInvocation)this.maybeAutoFormat((J)mi, (J)mi.withName(mi.getName().withSimpleName("compare")), ctx);
                    }
                }
            }
            return mi;
        }

        @Nullable
        private Expression getSingleArg(@Nullable List<Expression> args) {
            if (args != null && args.size() == 1 && !(args.get(0) instanceof J.Empty)) {
                return args.get(0);
            }
            return null;
        }
    }
}

