/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.NoMissingTypes;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveUnusedPrivateMethods
extends Recipe {
    public String getDisplayName() {
        return "Remove unused private methods";
    }

    public String getDescription() {
        return "`private` methods that are never executed are dead code and should be removed.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1144");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new NoMissingTypes(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, ExecutionContext ctx) {
                if (this.unusedWarningsSuppressed((J)classDeclaration)) {
                    return classDeclaration;
                }
                return super.visitClassDeclaration(classDeclaration, (Object)ctx);
            }

            private boolean unusedWarningsSuppressed(J classDeclaration) {
                for (J.Annotation annotation : FindAnnotations.find((J)classDeclaration, (String)"java.lang.SuppressWarnings")) {
                    List arguments = annotation.getArguments();
                    if (arguments == null) continue;
                    for (Expression argument : arguments) {
                        if (!J.Literal.isLiteralValue((Expression)argument, (Object)"unused")) continue;
                        return true;
                    }
                }
                return false;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                JavaType.Method methodType = method.getMethodType();
                if (methodType != null && methodType.hasFlags(new Flag[]{Flag.Private}) && !method.isConstructor() && ((AnnotationService)this.service(AnnotationService.class)).getAllAnnotations(this.getCursor()).isEmpty()) {
                    J.ClassDeclaration classDeclaration = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                    if (classDeclaration == null) {
                        return m;
                    }
                    if (TypeUtils.isAssignableTo((String)"java.io.Serializable", (JavaType)classDeclaration.getType())) {
                        switch (m.getSimpleName()) {
                            case "readObject": 
                            case "readObjectNoData": 
                            case "readResolve": 
                            case "writeObject": {
                                return m;
                            }
                        }
                    }
                    JavaSourceFile cu = (JavaSourceFile)this.getCursor().firstEnclosingOrThrow(JavaSourceFile.class);
                    for (JavaType.Method usedMethodType : cu.getTypesInUse().getUsedMethods()) {
                        if (!methodType.getName().equals(usedMethodType.getName()) || !methodType.equals((Object)usedMethodType)) continue;
                        return m;
                    }
                    for (JavaType javaType : cu.getTypesInUse().getTypesInUse()) {
                        if (!TypeUtils.isOfClassType((JavaType)javaType, (String)"org.junit.jupiter.params.provider.MethodSource")) continue;
                        return m;
                    }
                    for (JavaType.Method usedMethodType : cu.getTypesInUse().getDeclaredMethods()) {
                        if (!methodType.getName().equals(usedMethodType.getName()) || !methodType.equals((Object)usedMethodType) || !m.toString().contains("Generic{")) continue;
                        return m;
                    }
                    return null;
                }
                return m;
            }
        });
    }
}

