/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public class StaticMethodNotFinal
extends Recipe {
    public String getDisplayName() {
        return "Static methods not final";
    }

    public String getDescription() {
        return "Static methods do not need to be declared final because they cannot be overridden.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2333");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                if (m.hasModifier(J.Modifier.Type.Static) && m.hasModifier(J.Modifier.Type.Final)) {
                    m = m.withModifiers(ListUtils.map((List)m.getModifiers(), mod -> mod.getType() == J.Modifier.Type.Final ? null : mod));
                }
                return m;
            }
        };
    }
}

