/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class RemoveMethodCallVisitor<P>
extends JavaIsoVisitor<P> {
    private final MethodMatcher methodMatcher;
    private final BiPredicate<Integer, Expression> argumentPredicate;

    @Nullable
    public J.NewClass visitNewClass(J.NewClass newClass, P p) {
        return this.visitMethodCall(newClass, () -> super.visitNewClass(newClass, p));
    }

    @Nullable
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
        return this.visitMethodCall(method, () -> super.visitMethodInvocation(method, p));
    }

    @Nullable
    private <M extends MethodCall> M visitMethodCall(M methodCall, Supplier<M> visitSuper) {
        if (!this.methodMatcher.matches(methodCall)) {
            return (M)((MethodCall)visitSuper.get());
        }
        J.Block parentBlock = (J.Block)this.getCursor().firstEnclosing(J.Block.class);
        if (parentBlock != null && !parentBlock.getStatements().contains(methodCall)) {
            return (M)((MethodCall)visitSuper.get());
        }
        for (int i = 0; i < methodCall.getArguments().size(); ++i) {
            if (this.argumentPredicate.test(i, (Expression)methodCall.getArguments().get(i))) continue;
            return (M)((MethodCall)visitSuper.get());
        }
        if (methodCall.getMethodType() != null) {
            this.maybeRemoveImport(methodCall.getMethodType().getDeclaringType());
        }
        return null;
    }

    public RemoveMethodCallVisitor(MethodMatcher methodMatcher, BiPredicate<Integer, Expression> argumentPredicate) {
        this.methodMatcher = methodMatcher;
        this.argumentPredicate = argumentPredicate;
    }
}

