/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;

public class NoFinalizer
extends Recipe {
    public String getDisplayName() {
        return "Remove `finalize()` method";
    }

    public String getDescription() {
        return "Finalizers are deprecated. Use of `finalize()` can lead to performance issues, deadlocks, hangs, and other undesirable behavior.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1111");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(20L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new NoFinalizerVisitor();
    }

    private static class NoFinalizerVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher FINALIZER = new MethodMatcher("java.lang.Object finalize()", true);

        private NoFinalizerVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            cd = cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), stmt -> {
                if (stmt instanceof J.MethodDeclaration && FINALIZER.matches((J.MethodDeclaration)stmt, classDecl)) {
                    return null;
                }
                return stmt;
            })));
            return cd;
        }
    }
}

