/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.function.BiPredicate;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.staticanalysis.RemoveMethodCallVisitor;

public class RemoveUnneededAssertion
extends Recipe {
    private static final MethodMatcher JUNIT_JUPITER_ASSERT_TRUE_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(..)");
    private static final MethodMatcher JUNIT_JUPITER_ASSERT_FALSE_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertFalse(..)");
    private static final MethodMatcher JUNIT_ASSERT_TRUE_MATCHER = new MethodMatcher("org.junit.Assert assertTrue(boolean)");
    private static final MethodMatcher JUNIT_ASSERT_FALSE_MATCHER = new MethodMatcher("org.junit.Assert assertFalse(boolean)");
    private static final MethodMatcher JUNIT_ASSERT_MESSAGE_TRUE_MATCHER = new MethodMatcher("org.junit.Assert assertTrue(String, boolean)");
    private static final MethodMatcher JUNIT_ASSERT_MESSAGE_FALSE_MATCHER = new MethodMatcher("org.junit.Assert assertFalse(String, boolean)");

    public String getDisplayName() {
        return "Remove Unneeded Assertions";
    }

    public String getDescription() {
        return "Remove unneeded assertions like `assert true`, `assertTrue(true)`, or `assertFalse(false)`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(JUNIT_JUPITER_ASSERT_TRUE_MATCHER), new UsesMethod(JUNIT_JUPITER_ASSERT_FALSE_MATCHER), new UsesMethod(JUNIT_ASSERT_TRUE_MATCHER), new UsesMethod(JUNIT_ASSERT_FALSE_MATCHER), new UsesMethod(JUNIT_ASSERT_MESSAGE_TRUE_MATCHER), new UsesMethod(JUNIT_ASSERT_MESSAGE_FALSE_MATCHER), new JavaIsoVisitor<ExecutionContext>(){

            public J.Assert visitAssert(J.Assert _assert, ExecutionContext ctx) {
                if (J.Literal.isLiteralValue((Expression)_assert.getCondition(), (Object)true)) {
                    return (J.Assert)SearchResult.found((Tree)_assert);
                }
                return _assert;
            }
        }}), (TreeVisitor)new RemoveUnneededAssertionVisitor());
    }

    private static class RemoveUnneededAssertionVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private RemoveUnneededAssertionVisitor() {
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J.CompilationUnit compilationUnit = super.visitCompilationUnit(cu, (Object)ctx);
            TypesInUse typesInUse = compilationUnit.getTypesInUse();
            InvokeRemoveMethodCallVisitor invokeRemoveMethodCallVisitor = (inputCu, methodMatcher, argumentPredicate) -> {
                if (typesInUse.getUsedMethods().stream().anyMatch(arg_0 -> ((MethodMatcher)methodMatcher).matches(arg_0))) {
                    return (J.CompilationUnit)new RemoveMethodCallVisitor(methodMatcher, argumentPredicate).visitNonNull((Tree)cu, ctx, this.getCursor().getParentOrThrow());
                }
                return inputCu;
            };
            compilationUnit = invokeRemoveMethodCallVisitor.invoke(compilationUnit, JUNIT_JUPITER_ASSERT_TRUE_MATCHER, (arg, expr) -> !arg.equals(0) || J.Literal.isLiteralValue((Expression)expr, (Object)true));
            compilationUnit = invokeRemoveMethodCallVisitor.invoke(compilationUnit, JUNIT_JUPITER_ASSERT_FALSE_MATCHER, (arg, expr) -> !arg.equals(0) || J.Literal.isLiteralValue((Expression)expr, (Object)false));
            compilationUnit = invokeRemoveMethodCallVisitor.invoke(compilationUnit, JUNIT_ASSERT_TRUE_MATCHER, (arg, expr) -> arg.equals(0) && J.Literal.isLiteralValue((Expression)expr, (Object)true));
            compilationUnit = invokeRemoveMethodCallVisitor.invoke(compilationUnit, JUNIT_ASSERT_FALSE_MATCHER, (arg, expr) -> arg.equals(0) && J.Literal.isLiteralValue((Expression)expr, (Object)false));
            compilationUnit = invokeRemoveMethodCallVisitor.invoke(compilationUnit, JUNIT_ASSERT_MESSAGE_TRUE_MATCHER, (arg, expr) -> !arg.equals(1) || J.Literal.isLiteralValue((Expression)expr, (Object)true));
            compilationUnit = invokeRemoveMethodCallVisitor.invoke(compilationUnit, JUNIT_ASSERT_MESSAGE_FALSE_MATCHER, (arg, expr) -> !arg.equals(1) || J.Literal.isLiteralValue((Expression)expr, (Object)false));
            return compilationUnit;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable J.Assert visitAssert(J.Assert anAssert, ExecutionContext ctx) {
            if (anAssert.getCondition() instanceof J.Literal && J.Literal.isLiteralValue((Expression)anAssert.getCondition(), (Object)true)) {
                return null;
            }
            return super.visitAssert(anAssert, (Object)ctx);
        }

        @FunctionalInterface
        private static interface InvokeRemoveMethodCallVisitor {
            public J.CompilationUnit invoke(J.CompilationUnit var1, MethodMatcher var2, BiPredicate<Integer, Expression> var3);
        }
    }
}

