/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class BufferedWriterCreationRecipes
extends Recipe {
    public String getDisplayName() {
        return "Modernize `BufferedWriter` creation & prevent file descriptor leaks";
    }

    public String getDescription() {
        return "The code `new BufferedWriter(new FileWriter(f))` creates a `BufferedWriter` that does not close the underlying `FileWriter` when it is closed. This can lead to file descriptor leaks as per [CWE-755](https://cwe.mitre.org/data/definitions/755.html). Use `Files.newBufferedWriter` to create a `BufferedWriter` that closes the underlying file descriptor when it is closed.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new BufferedWriterFromNewFileWriterWithFileArgumentRecipe(), new BufferedWriterFromNewFileWriterWithStringArgumentRecipe(), new BufferedWriterFromNewFileWriterWithFileAndBooleanArgumentsRecipe(), new BufferedWriterFromNewFileWriterWithStringAndBooleanArgumentsRecipe()});
    }

    @NullMarked
    public static class BufferedWriterFromNewFileWriterWithFileArgumentRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Convert `new BufferedWriter(new FileWriter(File))` to `Files.newBufferedWriter(Path)`";
        }

        public String getDescription() {
            return "Convert `new BufferedWriter(new FileWriter(f))` to `Files.newBufferedWriter(f.toPath())`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"new java.io.BufferedWriter(new java.io.FileWriter(#{f:any(java.io.File)}))").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedWriter(#{f:any(java.io.File)}.toPath())").build();

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.io.FileWriter");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.BufferedWriter", Boolean.valueOf(true)), new UsesType("java.io.FileWriter", Boolean.valueOf(true)), new UsesType("java.io.File", Boolean.valueOf(true)), new UsesMethod("java.io.BufferedWriter <constructor>(..)", true), new UsesMethod("java.io.FileWriter <constructor>(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class BufferedWriterFromNewFileWriterWithStringArgumentRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Convert `new BufferedWriter(new FileWriter(String))` to `Files.newBufferedWriter(Path)`";
        }

        public String getDescription() {
            return "Convert `new BufferedWriter(new FileWriter(s))` to `Files.newBufferedWriter(new java.io.File(s).toPath())`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"new java.io.BufferedWriter(new java.io.FileWriter(#{s:any(java.lang.String)}))").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedWriter(new java.io.File(#{s:any(java.lang.String)}).toPath())").build();

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.io.FileWriter");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.BufferedWriter", Boolean.valueOf(true)), new UsesType("java.io.FileWriter", Boolean.valueOf(true)), new UsesMethod("java.io.BufferedWriter <constructor>(..)", true), new UsesMethod("java.io.FileWriter <constructor>(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class BufferedWriterFromNewFileWriterWithFileAndBooleanArgumentsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Convert `new BufferedWriter(new FileWriter(File, boolean))` to `Files.newBufferedWriter(Path, StandardOpenOption)`";
        }

        public String getDescription() {
            return "Convert `new BufferedWriter(new FileWriter(f, b))` to `Files.newBufferedWriter(f.toPath(), b ? StandardOpenOption.APPEND : StandardOpenOption.CREATE)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"new java.io.BufferedWriter(new java.io.FileWriter(#{f:any(java.io.File)}, #{b:any(boolean)}))").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedWriter(#{f:any(java.io.File)}.toPath(), #{b:any(boolean)} ? java.nio.file.StandardOpenOption.APPEND : java.nio.file.StandardOpenOption.CREATE)").build();

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.io.FileWriter");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.BufferedWriter", Boolean.valueOf(true)), new UsesType("java.io.FileWriter", Boolean.valueOf(true)), new UsesType("java.io.File", Boolean.valueOf(true)), new UsesMethod("java.io.BufferedWriter <constructor>(..)", true), new UsesMethod("java.io.FileWriter <constructor>(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class BufferedWriterFromNewFileWriterWithStringAndBooleanArgumentsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Convert `new BufferedWriter(new FileWriter(String, boolean))` to `Files.newBufferedWriter(Path, StandardOpenOption)`";
        }

        public String getDescription() {
            return "Convert `new BufferedWriter(new FileWriter(s, b))` to `Files.newBufferedWriter(new java.io.File(s).toPath(), b ? StandardOpenOption.APPEND : StandardOpenOption.CREATE)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"new java.io.BufferedWriter(new java.io.FileWriter(#{s:any(java.lang.String)}, #{b:any(boolean)}))").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedWriter(new java.io.File(#{s:any(java.lang.String)}).toPath(), #{b:any(boolean)} ? java.nio.file.StandardOpenOption.APPEND : java.nio.file.StandardOpenOption.CREATE)").build();

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.io.FileWriter");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.BufferedWriter", Boolean.valueOf(true)), new UsesType("java.io.FileWriter", Boolean.valueOf(true)), new UsesMethod("java.io.BufferedWriter <constructor>(..)", true), new UsesMethod("java.io.FileWriter <constructor>(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

