/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

@Incubating(since="7.0.0")
public class CovariantEquals
extends Recipe {
    public String getDisplayName() {
        return "Covariant equals";
    }

    public String getDescription() {
        return "Checks that classes and records which define a covariant `equals()` method also override method `equals(Object)`. Covariant `equals()` means a method that is similar to `equals(Object)`, but with a covariant parameter type (any subtype of `Object`).";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S2162");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher objectEquals = new MethodMatcher("* equals(java.lang.Object)");
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                Stream<J.MethodDeclaration> mds = cd.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast);
                if (cd.getKind() != J.ClassDeclaration.Kind.Type.Interface && mds.noneMatch(m -> objectEquals.matches(m, classDecl))) {
                    cd = (J.ClassDeclaration)new ChangeCovariantEqualsMethodVisitor(cd).visit((Tree)cd, ctx, this.getCursor().getParentOrThrow());
                    assert (cd != null);
                }
                return cd;
            }

            class ChangeCovariantEqualsMethodVisitor
            extends JavaIsoVisitor<ExecutionContext> {
                private final AnnotationMatcher OVERRIDE_ANNOTATION = new AnnotationMatcher("@java.lang.Override");
                private final J.ClassDeclaration enclosingClass;

                public ChangeCovariantEqualsMethodVisitor(J.ClassDeclaration enclosingClass) {
                    this.enclosingClass = enclosingClass;
                }

                public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                    J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                    this.updateCursor((Tree)m);
                    JavaType.FullyQualified type = this.enclosingClass.getType();
                    if (type == null || type instanceof JavaType.Unknown) {
                        return m;
                    }
                    String ecfqn = type.getFullyQualifiedName();
                    if (m.hasModifier(J.Modifier.Type.Public) && m.getReturnTypeExpression() != null && JavaType.Primitive.Boolean.equals((Object)m.getReturnTypeExpression().getType()) && new MethodMatcher(ecfqn + " equals(" + ecfqn + ")").matches(m, this.enclosingClass)) {
                        J.VariableDeclarations.NamedVariable oldParamName;
                        if (!((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor(), this.OVERRIDE_ANNOTATION)) {
                            m = (J.MethodDeclaration)JavaTemplate.builder((String)"@Override").build().apply(this.updateCursor((Tree)m), m.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                        }
                        String paramName = "obj".equals((oldParamName = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)m.getParameters().get(0)).getVariables().get(0)).getSimpleName()) ? "other" : "obj";
                        m = (J.MethodDeclaration)JavaTemplate.builder((String)"Object #{}").build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceParameters(), new Object[]{paramName});
                        String equalsBodyPrefixTemplate = "if (#{} == this) return true;\nif (#{} == null || getClass() != #{}.getClass()) return false;\n#{} #{} = (#{}) #{};\n";
                        JavaTemplate equalsBodySnippet = JavaTemplate.builder((String)equalsBodyPrefixTemplate).contextSensitive().build();
                        assert (m.getBody() != null);
                        Object[] params = new Object[]{paramName, paramName, paramName, this.enclosingClass.getSimpleName(), oldParamName.getSimpleName(), this.enclosingClass.getSimpleName(), paramName};
                        m = (J.MethodDeclaration)equalsBodySnippet.apply(new Cursor(this.getCursor().getParent(), (Object)m), ((Statement)m.getBody().getStatements().get(0)).getCoordinates().before(), params);
                    }
                    return m;
                }
            }
        };
    }
}

