/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public class UseJavaStyleArrayDeclarations
extends Recipe {
    public String getDisplayName() {
        return "No C-style array declarations";
    }

    public String getDescription() {
        return "Change C-Style array declarations `int i[];` to `int[] i;`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1197");
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations varDecls = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                List dimensions = (List)this.getCursor().pollMessage("VAR_DIMENSIONS");
                if (dimensions != null) {
                    varDecls = varDecls.withDimensionsBeforeName(dimensions);
                }
                return varDecls;
            }

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
                J.VariableDeclarations.NamedVariable nv = super.visitVariable(variable, (Object)ctx);
                if (!nv.getDimensionsAfterName().isEmpty()) {
                    this.getCursor().dropParentUntil(J.VariableDeclarations.class::isInstance).putMessage("VAR_DIMENSIONS", (Object)nv.getDimensionsAfterName());
                    nv = nv.withDimensionsAfterName(ListUtils.map((List)nv.getDimensionsAfterName(), dim -> null));
                }
                return nv;
            }
        };
    }
}

