/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.DefaultComesLastStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.staticanalysis.DefaultComesLastVisitor;

public class DefaultComesLast
extends Recipe {
    public String getDisplayName() {
        return "Default comes last";
    }

    public String getDescription() {
        return "Ensure the `default` case comes last after all the cases in a switch statement.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S4524");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new DefaultComesLastFromCompilationUnitStyle();
    }

    private static class DefaultComesLastFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private DefaultComesLastFromCompilationUnitStyle() {
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                DefaultComesLastStyle style = (DefaultComesLastStyle)cu.getStyle(DefaultComesLastStyle.class);
                if (style == null) {
                    style = Checkstyle.defaultComesLast();
                }
                return (J)new DefaultComesLastVisitor(style).visit((Tree)cu, ctx);
            }
            return (J)tree;
        }
    }
}

