/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

public class WriteOctalValuesAsDecimal
extends Recipe {
    public String getDisplayName() {
        return "Write octal values as decimal";
    }

    public String getDescription() {
        return "Developers may not recognize octal values as such, mistaking them instead for decimal values.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1314");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitLiteral(J.Literal literal, ExecutionContext ctx) {
                String src = literal.getValueSource();
                if (src != null && src.startsWith("0") && src.length() >= 2 && src.charAt(1) != 'x' && src.charAt(1) != 'X' && src.charAt(1) != 'b' && src.charAt(1) != 'B' && src.charAt(1) != '.' && src.charAt(src.length() - 1) != 'L' && src.charAt(src.length() - 1) != 'l' && src.charAt(src.length() - 1) != 'F' && src.charAt(src.length() - 1) != 'f' && src.charAt(src.length() - 1) != 'D' && src.charAt(src.length() - 1) != 'd' && !src.contains(".")) {
                    assert (literal.getValue() != null);
                    return literal.withValueSource(literal.getValue().toString());
                }
                return super.visitLiteral(literal, (Object)ctx);
            }
        };
    }
}

