/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class NewStringBuilderBufferWithCharArgument
extends Recipe {
    public String getDisplayName() {
        return "Change `StringBuilder` and `StringBuffer` character constructor argument to `String`";
    }

    public String getDescription() {
        return "Instantiating a `StringBuilder` or a `StringBuffer` with a `Character` results in the `int` representation of the character being used for the initial size.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1317");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor condition = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.lang.StringBuilder", Boolean.valueOf(true)), new UsesType("java.lang.StringBuffer", Boolean.valueOf(true))});
        return Preconditions.check((TreeVisitor)condition, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final JavaTemplate toString = JavaTemplate.builder((String)"String.valueOf(#{any()})").build();

            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
                J.NewClass nc = super.visitNewClass(newClass, (Object)executionContext);
                if (TypeUtils.isOfClassType((JavaType)nc.getType(), (String)"java.lang.StringBuilder") || TypeUtils.isOfClassType((JavaType)nc.getType(), (String)"java.lang.StringBuffer")) {
                    nc.getArguments();
                    if (((Expression)nc.getArguments().get(0)).getType() == JavaType.Primitive.Char) {
                        nc = nc.withArguments(ListUtils.mapFirst((List)nc.getArguments(), arg -> {
                            if (arg instanceof J.Literal) {
                                J.Literal l = (J.Literal)arg;
                                if ((l = l.withType(JavaType.buildType((String)"String"))).getValueSource() != null) {
                                    l = l.withValueSource(l.getValueSource().replace("'", "\""));
                                }
                                return l;
                            }
                            Cursor argCursor = new Cursor(this.getCursor(), arg);
                            return (Expression)this.toString.apply(argCursor, arg.getCoordinates().replace(), new Object[]{arg});
                        }));
                    }
                }
                return nc;
            }
        });
    }
}

