/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

@Incubating(since="7.0.0")
public class FinalizeLocalVariables
extends Recipe {
    public String getDisplayName() {
        return "Finalize local variables";
    }

    public String getDescription() {
        return "Adds the `final` modifier keyword to local variables which are not reassigned.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext p) {
                J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, (Object)p);
                if (mv.hasModifier(J.Modifier.Type.Final)) {
                    return mv;
                }
                if (mv.getVariables().stream().anyMatch(nv -> nv.getInitializer() == null)) {
                    return mv;
                }
                if (FinalizeLocalVariables.this.isDeclaredInForLoopControl(this.getCursor())) {
                    return mv;
                }
                if (mv.getVariables().stream().anyMatch(v -> v.isField(this.getCursor()))) {
                    return mv;
                }
                if (this.getCursorToParentScope(this.getCursor()).getValue() instanceof J.NewClass) {
                    return mv;
                }
                if (mv.getVariables().stream().noneMatch(v -> {
                    Cursor declaringCursor = v.getDeclaringScope(this.getCursor());
                    return FindAssignmentReferencesToVariable.find((J)declaringCursor.getValue(), v).get();
                })) {
                    mv = (J.VariableDeclarations)this.autoFormat((J)mv.withModifiers(ListUtils.concat((List)mv.getModifiers(), (Object)new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, J.Modifier.Type.Final, Collections.emptyList()))), p);
                }
                return mv;
            }

            private Cursor getCursorToParentScope(Cursor cursor) {
                return cursor.dropParentUntil(is -> is instanceof J.NewClass || is instanceof J.ClassDeclaration);
            }
        };
    }

    private boolean isDeclaredInForLoopControl(Cursor cursor) {
        return cursor.getParentTreeCursor().getValue() instanceof J.ForLoop.Control;
    }

    private static final class FindAssignmentReferencesToVariable
    extends JavaIsoVisitor<AtomicBoolean> {
        private final J.VariableDeclarations.NamedVariable variable;

        static AtomicBoolean find(J j, J.VariableDeclarations.NamedVariable variable) {
            return (AtomicBoolean)new FindAssignmentReferencesToVariable(variable).reduce((Tree)j, new AtomicBoolean());
        }

        public J.Assignment visitAssignment(J.Assignment assignment, AtomicBoolean hasAssignment) {
            J.Identifier i;
            if (hasAssignment.get()) {
                return assignment;
            }
            J.Assignment a = super.visitAssignment(assignment, (Object)hasAssignment);
            if (a.getVariable() instanceof J.Identifier && (i = (J.Identifier)a.getVariable()).getSimpleName().equals(this.variable.getSimpleName())) {
                hasAssignment.set(true);
            }
            return a;
        }

        public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, AtomicBoolean hasAssignment) {
            J.Identifier i;
            if (hasAssignment.get()) {
                return assignOp;
            }
            J.AssignmentOperation a = super.visitAssignmentOperation(assignOp, (Object)hasAssignment);
            if (a.getVariable() instanceof J.Identifier && (i = (J.Identifier)a.getVariable()).getSimpleName().equals(this.variable.getSimpleName())) {
                hasAssignment.set(true);
            }
            return a;
        }

        public J.Unary visitUnary(J.Unary unary, AtomicBoolean hasAssignment) {
            J.Identifier i;
            if (hasAssignment.get()) {
                return unary;
            }
            J.Unary u = super.visitUnary(unary, (Object)hasAssignment);
            if (u.getOperator().isModifying() && u.getExpression() instanceof J.Identifier && (i = (J.Identifier)u.getExpression()).getSimpleName().equals(this.variable.getSimpleName())) {
                hasAssignment.set(true);
            }
            return u;
        }

        public FindAssignmentReferencesToVariable(J.VariableDeclarations.NamedVariable variable) {
            this.variable = variable;
        }

        public J.VariableDeclarations.NamedVariable getVariable() {
            return this.variable;
        }

        public String toString() {
            return "FinalizeLocalVariables.FindAssignmentReferencesToVariable(variable=" + this.getVariable() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FindAssignmentReferencesToVariable)) {
                return false;
            }
            FindAssignmentReferencesToVariable other = (FindAssignmentReferencesToVariable)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            J.VariableDeclarations.NamedVariable this$variable = this.getVariable();
            J.VariableDeclarations.NamedVariable other$variable = other.getVariable();
            return !(this$variable == null ? other$variable != null : !this$variable.equals(other$variable));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FindAssignmentReferencesToVariable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            J.VariableDeclarations.NamedVariable $variable = this.getVariable();
            result = result * 59 + ($variable == null ? 43 : $variable.hashCode());
            return result;
        }
    }
}

