/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class RemoveCallsToObjectFinalize
extends Recipe {
    private static final MethodMatcher OBJECT_FINALIZE = new MethodMatcher("java.lang.Object finalize()");

    public String getDisplayName() {
        return "Remove `Object.finalize()` invocations";
    }

    public String getDescription() {
        return "Remove calls to `Object.finalize()`. This method is called during garbage collection and calling it manually is misleading.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1111");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(OBJECT_FINALIZE), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation invocation = super.visitMethodInvocation(method, (Object)context);
                if (invocation.getMethodType() != null && "finalize".equals(invocation.getMethodType().getName()) && invocation.getMethodType().getDeclaringType().getSupertype() != null && Object.class.getName().equals(invocation.getMethodType().getDeclaringType().getSupertype().getFullyQualifiedName())) {
                    return null;
                }
                return invocation;
            }
        });
    }
}

